/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.EmailAddress;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.EmailAddressUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseEmailAddressResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.EmailAddressResource;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.vulcan.pagination.Page;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/email-address.properties"}, scope=ServiceScope.PROTOTYPE, service={EmailAddressResource.class})
public class EmailAddressResourceImpl
extends BaseEmailAddressResourceImpl {
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private UserService _userService;

    @Override
    public EmailAddress getEmailAddress(Long emailAddressId) throws Exception {
        return EmailAddressUtil.toEmailAddress(this._emailAddressService.getEmailAddress(emailAddressId.longValue()));
    }

    @Override
    public Page<EmailAddress> getOrganizationEmailAddressesPage(Long organizationId) throws Exception {
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        return Page.of(this.transform(this._emailAddressService.getEmailAddresses(organization.getModelClassName(), organization.getOrganizationId()), EmailAddressUtil::toEmailAddress));
    }

    @Override
    public Page<EmailAddress> getUserAccountEmailAddressesPage(Long userAccountId) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        return Page.of(this.transform(this._emailAddressService.getEmailAddresses(Contact.class.getName(), user.getContactId()), EmailAddressUtil::toEmailAddress));
    }
}

