/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.WebUrlUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseWebUrlResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.WebUrlResource;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.vulcan.pagination.Page;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/web-url.properties"}, scope=ServiceScope.PROTOTYPE, service={WebUrlResource.class})
public class WebUrlResourceImpl
extends BaseWebUrlResourceImpl {
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private UserService _userService;
    @Reference
    private WebsiteService _websiteService;

    @Override
    public Page<WebUrl> getOrganizationWebUrlsPage(Long organizationId) throws Exception {
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        return Page.of(this.transform(this._websiteService.getWebsites(organization.getModelClassName(), organization.getOrganizationId()), WebUrlUtil::toWebUrl));
    }

    @Override
    public Page<WebUrl> getUserAccountWebUrlsPage(Long userAccountId) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        return Page.of(this.transform(this._websiteService.getWebsites(Contact.class.getName(), user.getContactId()), WebUrlUtil::toWebUrl));
    }

    @Override
    public WebUrl getWebUrl(Long webUrlId) throws Exception {
        return WebUrlUtil.toWebUrl(this._websiteService.getWebsite(webUrlId.longValue()));
    }
}

