/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Role;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseRoleResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.RoleResource;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/role.properties"}, scope=ServiceScope.PROTOTYPE, service={RoleResource.class})
public class RoleResourceImpl
extends BaseRoleResourceImpl {
    @Reference
    private Portal _portal;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Role getRole(Long roleId) throws Exception {
        return this._toRole(this._roleService.getRole(roleId.longValue()));
    }

    @Override
    public Page<Role> getRolesPage(Pagination pagination) throws Exception {
        Integer[] types = new Integer[]{3, 1, 2};
        return Page.of(this.transform(this._roleService.search(this.contextCompany.getCompanyId(), null, types, null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toRole), (Pagination)pagination, (long)this._roleService.searchCount(this.contextCompany.getCompanyId(), null, types, null));
    }

    private Role _toRole(final com.liferay.portal.kernel.model.Role role) throws Exception {
        return new Role(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])role.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(RoleResourceImpl.this._portal, RoleResourceImpl.this._userLocalService.getUserById(role.getUserId()));
                this.dateCreated = role.getCreateDate();
                this.dateModified = role.getModifiedDate();
                this.description = role.getDescription(RoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = role.getRoleId();
                this.name = role.getTitle(RoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.roleType = role.getTypeLabel();
            }
        };
    }
}

