/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PostalAddressUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BasePostalAddressResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.PostalAddressResource;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.AddressService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.service.permission.CommonPermissionUtil;
import com.liferay.portal.vulcan.pagination.Page;
import javax.ws.rs.core.Context;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/postal-address.properties"}, scope=ServiceScope.PROTOTYPE, service={PostalAddressResource.class})
public class PostalAddressResourceImpl
extends BasePostalAddressResourceImpl {
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private AddressService _addressService;
    @Reference
    private OrganizationService _organizationService;
    @Context
    private User _user;
    @Reference
    private UserService _userService;

    @Override
    public Page<PostalAddress> getOrganizationPostalAddressesPage(Long organizationId) throws Exception {
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        return Page.of(this.transform(this._addressLocalService.getAddresses(this.contextCompany.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId()), address -> PostalAddressUtil.toPostalAddress(address, this.contextAcceptLanguage.getPreferredLocale())));
    }

    @Override
    public PostalAddress getPostalAddress(Long postalAddressId) throws Exception {
        return PostalAddressUtil.toPostalAddress(this._addressService.getAddress(postalAddressId.longValue()), this.contextAcceptLanguage.getPreferredLocale());
    }

    @Override
    public Page<PostalAddress> getUserAccountPostalAddressesPage(Long userAccountId) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        CommonPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (String)user.getModelClassName(), (long)user.getUserId(), (String)"VIEW");
        return Page.of(this.transform(this._addressLocalService.getAddresses(user.getCompanyId(), Contact.class.getName(), user.getContactId()), address -> PostalAddressUtil.toPostalAddress(address, this.contextAcceptLanguage.getPreferredLocale())));
    }
}

