/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.resource.v1_0.PostalAddressResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BasePostalAddressResourceImpl
implements PostalAddressResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @GET
    @Operation(description="Retrieves the organization's postal addresses.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Path(value="/organizations/{organizationId}/postal-addresses")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="PostalAddress")})
    public Page<PostalAddress> getOrganizationPostalAddressesPage(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") Long organizationId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves the postal address.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="postalAddressId")})
    @Path(value="/postal-addresses/{postalAddressId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="PostalAddress")})
    public PostalAddress getPostalAddress(@NotNull @Parameter(hidden=true) @PathParam(value="postalAddressId") Long postalAddressId) throws Exception {
        return new PostalAddress();
    }

    @GET
    @Operation(description="Retrieves the user's postal addresses.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Path(value="/user-accounts/{userAccountId}/postal-addresses")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="PostalAddress")})
    public Page<PostalAddress> getUserAccountPostalAddressesPage(@NotNull @Parameter(hidden=true) @PathParam(value="userAccountId") Long userAccountId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(PostalAddress postalAddress, PostalAddress existingPostalAddress) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

