/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseOrganizationResourceImpl
implements OrganizationResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @GET
    @Operation(description="Retrieves the organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/organizations")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Organization")})
    public Page<Organization> getOrganizationsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves the organization.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Path(value="/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Organization")})
    public Organization getOrganization(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") Long organizationId) throws Exception {
        return new Organization();
    }

    @GET
    @Operation(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentOrganizationId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/organizations/{parentOrganizationId}/organizations")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Organization")})
    public Page<Organization> getOrganizationOrganizationsPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentOrganizationId") Long parentOrganizationId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(Organization organization, Organization existingOrganization) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

