/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.util;

import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Region;
import java.util.Locale;

public class PostalAddressUtil {
    public static PostalAddress toPostalAddress(final Address address, final Locale locale) {
        final ListType listType = address.getType();
        return new PostalAddress(){
            {
                this.addressLocality = address.getCity();
                this.addressType = listType.getName();
                this.id = address.getAddressId();
                this.postalCode = address.getZip();
                this.primary = address.isPrimary();
                this.streetAddressLine1 = address.getStreet1();
                this.streetAddressLine2 = address.getStreet2();
                this.streetAddressLine3 = address.getStreet3();
                this.setAddressCountry(() -> {
                    if (address.getCountryId() <= 0L) {
                        return null;
                    }
                    Country country = address.getCountry();
                    return country.getName(locale);
                });
                this.setAddressRegion(() -> {
                    if (address.getRegionId() <= 0L) {
                        return null;
                    }
                    Region region = address.getRegion();
                    return region.getName();
                });
            }
        };
    }
}

