/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.util;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.headless.admin.user.dto.v1_0.CustomField;
import com.liferay.headless.admin.user.dto.v1_0.CustomValue;
import com.liferay.headless.admin.user.dto.v1_0.Geo;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class CustomFieldsUtil {
    public static CustomField[] toCustomFields(String className, long classPK, long companyId, Locale locale) {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)companyId, (String)className, (long)classPK);
        Map attributes = expandoBridge.getAttributes();
        Set entries = attributes.entrySet();
        return (CustomField[])entries.stream().filter(entry -> {
            UnicodeProperties unicodeProperties = expandoBridge.getAttributeProperties((String)entry.getKey());
            return !GetterUtil.getBoolean((String)unicodeProperties.getProperty("hidden"));
        }).map(entry -> CustomFieldsUtil._toCustomField(entry, expandoBridge, locale)).toArray(CustomField[]::new);
    }

    private static Object _getValue(int attributeType, Locale locale, Object value) {
        if (20 == attributeType) {
            return ((Map)value).get(locale);
        }
        if (3 == attributeType) {
            return DateUtil.getDate((Date)((Date)value), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Locale)locale, (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        return value;
    }

    private static boolean _isEmpty(Object value) {
        Map map;
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray() && Array.getLength(value) == 0) {
            return true;
        }
        return value instanceof Map && (map = (Map)value).isEmpty();
    }

    private static CustomField _toCustomField(final Map.Entry<String, Serializable> entry, final ExpandoBridge expandoBridge, final Locale locale) {
        final String key = entry.getKey();
        final int attributeType = expandoBridge.getAttributeType(key);
        if (21 == attributeType) {
            return new CustomField(){
                {
                    this.dataType = "Geolocation";
                    this.name = (String)entry.getKey();
                    this.setCustomValue(() -> {
                        final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(entry.getValue()));
                        return new CustomValue(){
                            {
                                this.geo = new Geo(){
                                    {
                                        this.latitude = jsonObject.getDouble("latitude");
                                        this.longitude = jsonObject.getDouble("longitude");
                                    }
                                };
                            }
                        };
                    });
                }
            };
        }
        return new CustomField(){
            {
                this.customValue = new CustomValue(){
                    {
                        Object value = entry.getValue();
                        if (CustomFieldsUtil._isEmpty(entry.getValue())) {
                            value = expandoBridge.getAttributeDefault(key);
                        }
                        this.data = CustomFieldsUtil._getValue(attributeType, locale, value);
                    }
                };
                this.dataType = ExpandoColumnConstants.getDataType((int)attributeType);
                this.name = (String)entry.getKey();
            }
        };
    }
}

