/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.CustomField;
import com.liferay.headless.admin.user.dto.v1_0.Location;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.Service;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents an organization. Organizations can contain other organizations (suborganizations). Properties follow the [Organization](https://schema.org/Organization) specification.", value="Organization")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Organization")
public class Organization
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Organization[] childOrganizations;
    @GraphQLField(description="The text of a comment associated with the organization.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The text of a comment associated with the organization.") String comment;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField(description="The organization's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The organization's creation date.") Date dateCreated;
    @GraphQLField(description="The most recent time any of the organization's fields changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The most recent time any of the organization's fields changed.") Date dateModified;
    @GraphQLField(description="The optional external key of this organization.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The optional external key of this organization.") String externalReferenceCode;
    @GraphQLField(description="The organization's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The organization's ID.") String id;
    @GraphQLField(description="A relative URL to the organization's image.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A relative URL to the organization's image.") String image;
    @GraphQLField(description="A list of keywords describing the organization.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A list of keywords describing the organization.") String[] keywords;
    @GraphQLField(description="The organization's postal information (country and region).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The organization's postal information (country and region).") Location location;
    @GraphQLField(description="The organization's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The organization's name.") String name;
    @GraphQLField(description="The number of this organization's associated accounts.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this organization's associated accounts.") Integer numberOfAccounts;
    @GraphQLField(description="The number of this organization's child organizations.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this organization's child organizations.") Integer numberOfOrganizations;
    @GraphQLField(description="The number of this organization's associated users.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this organization's associated users.") Integer numberOfUsers;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Account[] organizationAccounts;
    @GraphQLField(description="The organization's contact information, which includes email addresses, postal addresses, phone numbers, and web URLs. This is modeled internally as a `Contact`.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The organization's contact information, which includes email addresses, postal addresses, phone numbers, and web URLs. This is modeled internally as a `Contact`.") OrganizationContactInformation organizationContactInformation;
    @GraphQLField(description="The organization's parent organization.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The organization's parent organization.") Organization parentOrganization;
    @GraphQLField(description="A list of services the organization provides. This follows the [`Service`](https://www.schema.org/Service) specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of services the organization provides. This follows the [`Service`](https://www.schema.org/Service) specification.") Service[] services;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected UserAccount[] userAccounts;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.user.dto.v1_0.Organization", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static Organization toDTO(String json) {
        return (Organization)ObjectMapperUtil.readValue(Organization.class, (String)json);
    }

    public static Organization unsafeToDTO(String json) {
        return (Organization)ObjectMapperUtil.unsafeReadValue(Organization.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Organization[] getChildOrganizations() {
        return this.childOrganizations;
    }

    public void setChildOrganizations(Organization[] childOrganizations) {
        this.childOrganizations = childOrganizations;
    }

    @JsonIgnore
    public void setChildOrganizations(UnsafeSupplier<Organization[], Exception> childOrganizationsUnsafeSupplier) {
        try {
            this.childOrganizations = (Organization[])childOrganizationsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The text of a comment associated with the organization.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonIgnore
    public void setComment(UnsafeSupplier<String, Exception> commentUnsafeSupplier) {
        try {
            this.comment = (String)commentUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The most recent time any of the organization's fields changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The optional external key of this organization.")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<String, Exception> idUnsafeSupplier) {
        try {
            this.id = (String)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A relative URL to the organization's image.")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonIgnore
    public void setImage(UnsafeSupplier<String, Exception> imageUnsafeSupplier) {
        try {
            this.image = (String)imageUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the organization.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's postal information (country and region).")
    @Valid
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @JsonIgnore
    public void setLocation(UnsafeSupplier<Location, Exception> locationUnsafeSupplier) {
        try {
            this.location = (Location)locationUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of this organization's associated accounts.")
    public Integer getNumberOfAccounts() {
        return this.numberOfAccounts;
    }

    public void setNumberOfAccounts(Integer numberOfAccounts) {
        this.numberOfAccounts = numberOfAccounts;
    }

    @JsonIgnore
    public void setNumberOfAccounts(UnsafeSupplier<Integer, Exception> numberOfAccountsUnsafeSupplier) {
        try {
            this.numberOfAccounts = (Integer)numberOfAccountsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of this organization's child organizations.")
    public Integer getNumberOfOrganizations() {
        return this.numberOfOrganizations;
    }

    public void setNumberOfOrganizations(Integer numberOfOrganizations) {
        this.numberOfOrganizations = numberOfOrganizations;
    }

    @JsonIgnore
    public void setNumberOfOrganizations(UnsafeSupplier<Integer, Exception> numberOfOrganizationsUnsafeSupplier) {
        try {
            this.numberOfOrganizations = (Integer)numberOfOrganizationsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of this organization's associated users.")
    public Integer getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public void setNumberOfUsers(Integer numberOfUsers) {
        this.numberOfUsers = numberOfUsers;
    }

    @JsonIgnore
    public void setNumberOfUsers(UnsafeSupplier<Integer, Exception> numberOfUsersUnsafeSupplier) {
        try {
            this.numberOfUsers = (Integer)numberOfUsersUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Account[] getOrganizationAccounts() {
        return this.organizationAccounts;
    }

    public void setOrganizationAccounts(Account[] organizationAccounts) {
        this.organizationAccounts = organizationAccounts;
    }

    @JsonIgnore
    public void setOrganizationAccounts(UnsafeSupplier<Account[], Exception> organizationAccountsUnsafeSupplier) {
        try {
            this.organizationAccounts = (Account[])organizationAccountsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's contact information, which includes email addresses, postal addresses, phone numbers, and web URLs. This is modeled internally as a `Contact`.")
    @Valid
    public OrganizationContactInformation getOrganizationContactInformation() {
        return this.organizationContactInformation;
    }

    public void setOrganizationContactInformation(OrganizationContactInformation organizationContactInformation) {
        this.organizationContactInformation = organizationContactInformation;
    }

    @JsonIgnore
    public void setOrganizationContactInformation(UnsafeSupplier<OrganizationContactInformation, Exception> organizationContactInformationUnsafeSupplier) {
        try {
            this.organizationContactInformation = (OrganizationContactInformation)organizationContactInformationUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's parent organization.")
    @Valid
    public Organization getParentOrganization() {
        return this.parentOrganization;
    }

    public void setParentOrganization(Organization parentOrganization) {
        this.parentOrganization = parentOrganization;
    }

    @JsonIgnore
    public void setParentOrganization(UnsafeSupplier<Organization, Exception> parentOrganizationUnsafeSupplier) {
        try {
            this.parentOrganization = (Organization)parentOrganizationUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of services the organization provides. This follows the [`Service`](https://www.schema.org/Service) specification.")
    @Valid
    public Service[] getServices() {
        return this.services;
    }

    public void setServices(Service[] services) {
        this.services = services;
    }

    @JsonIgnore
    public void setServices(UnsafeSupplier<Service[], Exception> servicesUnsafeSupplier) {
        try {
            this.services = (Service[])servicesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public UserAccount[] getUserAccounts() {
        return this.userAccounts;
    }

    public void setUserAccounts(UserAccount[] userAccounts) {
        this.userAccounts = userAccounts;
    }

    @JsonIgnore
    public void setUserAccounts(UnsafeSupplier<UserAccount[], Exception> userAccountsUnsafeSupplier) {
        try {
            this.userAccounts = (UserAccount[])userAccountsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Organization)) {
            return false;
        }
        Organization organization = (Organization)object;
        return Objects.equals(this.toString(), organization.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Organization._toJSON(this.actions));
        }
        if (this.childOrganizations != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"childOrganizations\": ");
            sb.append("[");
            for (i = 0; i < this.childOrganizations.length; ++i) {
                sb.append(String.valueOf(this.childOrganizations[i]));
                if (i + 1 >= this.childOrganizations.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.comment != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"comment\": ");
            sb.append("\"");
            sb.append(Organization._escape(this.comment));
            sb.append("\"");
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Organization._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append("\"");
            sb.append(Organization._escape(this.id));
            sb.append("\"");
        }
        if (this.image != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"image\": ");
            sb.append("\"");
            sb.append(Organization._escape(this.image));
            sb.append("\"");
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(Organization._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.location != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"location\": ");
            sb.append(String.valueOf(this.location));
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Organization._escape(this.name));
            sb.append("\"");
        }
        if (this.numberOfAccounts != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfAccounts\": ");
            sb.append((Object)this.numberOfAccounts);
        }
        if (this.numberOfOrganizations != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfOrganizations\": ");
            sb.append((Object)this.numberOfOrganizations);
        }
        if (this.numberOfUsers != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfUsers\": ");
            sb.append((Object)this.numberOfUsers);
        }
        if (this.organizationAccounts != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizationAccounts\": ");
            sb.append("[");
            for (i = 0; i < this.organizationAccounts.length; ++i) {
                sb.append(String.valueOf(this.organizationAccounts[i]));
                if (i + 1 >= this.organizationAccounts.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.organizationContactInformation != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizationContactInformation\": ");
            sb.append(String.valueOf(this.organizationContactInformation));
        }
        if (this.parentOrganization != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentOrganization\": ");
            sb.append(String.valueOf(this.parentOrganization));
        }
        if (this.services != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"services\": ");
            sb.append("[");
            for (i = 0; i < this.services.length; ++i) {
                sb.append(String.valueOf(this.services[i]));
                if (i + 1 >= this.services.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.userAccounts != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userAccounts\": ");
            sb.append("[");
            for (i = 0; i < this.userAccounts.length; ++i) {
                sb.append(String.valueOf(this.userAccounts[i]));
                if (i + 1 >= this.userAccounts.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Organization._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Organization._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Organization._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Organization._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

