/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.asset.category.property.model.AssetCategoryProperty;
import com.liferay.asset.category.property.service.AssetCategoryPropertyLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategoryProperty;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.converter.TaxonomyCategoryDTOConverter;
import com.liferay.headless.admin.taxonomy.internal.odata.entity.v1_0.CategoryEntityModel;
import com.liferay.headless.admin.taxonomy.internal.resource.v1_0.BaseTaxonomyCategoryResourceImpl;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ContentLanguageUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portlet.asset.model.impl.AssetCategoryImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/taxonomy-category.properties"}, scope=ServiceScope.PROTOTYPE, service={TaxonomyCategoryResource.class})
public class TaxonomyCategoryResourceImpl
extends BaseTaxonomyCategoryResourceImpl {
    private static final EntityModel _entityModel = new CategoryEntityModel();
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetCategoryPropertyLocalService _assetCategoryPropertyLocalService;
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private TaxonomyCategoryDTOConverter _taxonomyCategoryDTOConverter;

    @Override
    public void deleteTaxonomyCategory(String taxonomyCategoryId) throws Exception {
        AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(GetterUtil.getLong((String)taxonomyCategoryId));
        this._assetCategoryService.deleteCategory(assetCategory.getCategoryId());
    }

    @Override
    public void deleteTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(Long taxonomyVocabularyId, String externalReferenceCode) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategoryByExternalReferenceCode(externalReferenceCode, assetVocabulary.getGroupId());
        this._assetCategoryService.deleteCategory(assetCategory.getCategoryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyCategoriesRankedPage(Long siteId, Pagination pagination) {
        DynamicQuery dynamicQuery = this._assetCategoryLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)this.contextCompany.getCompanyId()));
        if (siteId != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)siteId));
        }
        dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"assetCount"));
        dynamicQuery.setProjection((Projection)this._getProjectionList(), true);
        return Page.of(this.transform(this.transform(this._assetCategoryLocalService.dynamicQuery(dynamicQuery, pagination.getStartPosition(), pagination.getEndPosition()), this::_toAssetCategory), this::_toTaxonomyCategory), (Pagination)pagination, (long)this._getTotalCount(siteId));
    }

    @Override
    public TaxonomyCategory getTaxonomyCategory(String taxonomyCategoryId) throws Exception {
        AssetCategory assetCategory = this._getAssetCategory(taxonomyCategoryId);
        ContentLanguageUtil.addContentLanguageHeader((String[])assetCategory.getAvailableLanguageIds(), (String)assetCategory.getDefaultLanguageId(), (HttpServletResponse)this.contextHttpServletResponse, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        return this._toTaxonomyCategory(assetCategory);
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyCategoryTaxonomyCategoriesPage(String parentTaxonomyCategoryId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        HashMap actions = null;
        if (!Objects.equals(parentTaxonomyCategoryId, "0")) {
            AssetCategory assetCategory = this._getAssetCategory(parentTaxonomyCategoryId);
            parentTaxonomyCategoryId = String.valueOf(assetCategory.getCategoryId());
            actions = HashMapBuilder.put((Object)"add-category", this.addAction("ADD_CATEGORY", assetCategory.getCategoryId(), "postTaxonomyCategoryTaxonomyCategory", assetCategory.getUserId(), AssetCategory.class.getName(), assetCategory.getGroupId())).put((Object)"get", this.addAction("VIEW", assetCategory.getCategoryId(), "getTaxonomyCategoryTaxonomyCategoriesPage", assetCategory.getUserId(), AssetCategory.class.getName(), assetCategory.getGroupId())).build();
        }
        String taxonomyCategoryId = parentTaxonomyCategoryId;
        return this._getCategoriesPage(actions, aggregation, (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentCategoryId", taxonomyCategoryId), BooleanClauseOccur.MUST);
        }), filter, search, pagination, sorts);
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyVocabularyTaxonomyCategoriesPage(Long taxonomyVocabularyId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        return this._getCategoriesPage(HashMapBuilder.put((Object)"add-category", this.addAction("ADD_CATEGORY", (GroupedModel)assetVocabulary, "postTaxonomyVocabularyTaxonomyCategory")).put((Object)"createBatch", this.addAction("VIEW", (GroupedModel)assetVocabulary, "postTaxonomyVocabularyTaxonomyCategoryBatch")).put((Object)"deleteBatch", this.addAction("DELETE", (GroupedModel)assetVocabulary, "deleteTaxonomyCategoryBatch")).put((Object)"get", this.addAction("VIEW", (GroupedModel)assetVocabulary, "getTaxonomyVocabularyTaxonomyCategoriesPage")).put((Object)"updateBatch", this.addAction("UPDATE", (GroupedModel)assetVocabulary, "putTaxonomyCategoryBatch")).build(), aggregation, (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            booleanFilter.add((Filter)new TermFilter("assetVocabularyId", String.valueOf(taxonomyVocabularyId)), BooleanClauseOccur.MUST);
        }), filter, search, pagination, sorts);
    }

    @Override
    public TaxonomyCategory getTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(Long taxonomyVocabularyId, String externalReferenceCode) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        return this._toTaxonomyCategory(this._assetCategoryService.getAssetCategoryByExternalReferenceCode(assetVocabulary.getGroupId(), externalReferenceCode));
    }

    @Override
    public TaxonomyCategory patchTaxonomyCategory(String taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._getAssetCategory(taxonomyCategoryId);
        if (!ArrayUtil.contains((Object[])assetCategory.getAvailableLanguageIds(), (Object)this.contextAcceptLanguage.getPreferredLanguageId())) {
            throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to patch taxonomy category with language ", LocaleUtil.toW3cLanguageId((String)this.contextAcceptLanguage.getPreferredLanguageId()), " because it is only available in the following languages ", LocaleUtil.toW3cLanguageIds((String[])assetCategory.getAvailableLanguageIds())}));
        }
        assetCategory.setDescriptionMap(LocalizedMapUtil.patch((Map)assetCategory.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription(), (Map)taxonomyCategory.getDescription_i18n()));
        assetCategory.setTitleMap(LocalizedMapUtil.patch((Map)assetCategory.getTitleMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName(), (Map)taxonomyCategory.getName_i18n()));
        AssetCategoryPermission.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long)assetCategory.getCategoryId(), (String)"UPDATE");
        return this._toTaxonomyCategory(this._assetCategoryLocalService.updateCategory(this.contextUser.getUserId(), assetCategory.getCategoryId(), assetCategory.getParentCategoryId(), assetCategory.getTitleMap(), assetCategory.getDescriptionMap(), assetCategory.getVocabularyId(), this._merge(this._assetCategoryPropertyLocalService.getCategoryProperties(assetCategory.getCategoryId()), taxonomyCategory.getTaxonomyCategoryProperties()), ServiceContextRequestUtil.createServiceContext((long)assetCategory.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)taxonomyCategory.getViewableByAsString())));
    }

    @Override
    public TaxonomyCategory postTaxonomyCategoryTaxonomyCategory(String parentTaxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._getAssetCategory(parentTaxonomyCategoryId);
        return this._addTaxonomyCategory(taxonomyCategory.getExternalReferenceCode(), assetCategory.getGroupId(), assetCategory.getDefaultLanguageId(), taxonomyCategory, assetCategory.getCategoryId(), assetCategory.getVocabularyId());
    }

    @Override
    public TaxonomyCategory postTaxonomyVocabularyTaxonomyCategory(Long taxonomyVocabularyId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        return this._addTaxonomyCategory(taxonomyCategory.getExternalReferenceCode(), assetVocabulary.getGroupId(), assetVocabulary.getDefaultLanguageId(), taxonomyCategory, 0L, assetVocabulary.getVocabularyId());
    }

    @Override
    public TaxonomyCategory putTaxonomyCategory(String taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        return this._toTaxonomyCategory(this._updateAssetCategory(this._getAssetCategory(taxonomyCategoryId), taxonomyCategory));
    }

    @Override
    public TaxonomyCategory putTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(Long taxonomyVocabularyId, String externalReferenceCode, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(externalReferenceCode, assetVocabulary.getGroupId());
        if (assetCategory != null) {
            return this._toTaxonomyCategory(this._updateAssetCategory(assetCategory, taxonomyCategory));
        }
        return this._addTaxonomyCategory(externalReferenceCode, assetVocabulary.getGroupId(), assetVocabulary.getDefaultLanguageId(), taxonomyCategory, 0L, assetVocabulary.getVocabularyId());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        AssetCategory assetCategory = this._getAssetCategory((String)id);
        return assetCategory.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.asset.categories";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return AssetCategory.class.getName();
    }

    private TaxonomyCategory _addTaxonomyCategory(String externalReferenceCode, long groupId, String languageId, TaxonomyCategory taxonomyCategory, long taxonomyCategoryId, long taxonomyVocabularyId) throws Exception {
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName(), (Map)taxonomyCategory.getName_i18n());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription(), (Map)taxonomyCategory.getDescription_i18n());
        LocalizedMapUtil.validateI18n((boolean)true, (Locale)LocaleUtil.fromLanguageId((String)languageId), (String)"Taxonomy category", (Map)titleMap, new HashSet(descriptionMap.keySet()));
        return this._toTaxonomyCategory(this._assetCategoryService.addCategory(externalReferenceCode, groupId, taxonomyCategoryId, titleMap, descriptionMap, taxonomyVocabularyId, this._toStringArray(taxonomyCategory.getTaxonomyCategoryProperties()), ServiceContextRequestUtil.createServiceContext((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)taxonomyCategory.getViewableByAsString())));
    }

    private AssetCategory _getAssetCategory(String taxonomyCategoryId) throws Exception {
        return this._assetCategoryService.getCategory(GetterUtil.getLong((String)taxonomyCategoryId));
    }

    private Page<TaxonomyCategory> _getCategoriesPage(Map<String, Map<String, String>> actions, Aggregation aggregation, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Filter filter, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)filter, (String)AssetCategory.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"assetCategoryId"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toTaxonomyCategory(this._assetCategoryService.getCategory(GetterUtil.getLong((String)document.get("assetCategoryId")))));
    }

    private ProjectionList _getProjectionList() {
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(ProjectionFactoryUtil.alias((Projection)ProjectionFactoryUtil.sqlProjection((String)StringBundler.concat((String[])new String[]{"COALESCE((select count(assetEntryId) assetCount from ", "AssetEntryAssetCategoryRel where assetCategoryId = ", "this_.categoryId group by assetCategoryId), 0) AS ", "assetCount"}), (String[])new String[]{"assetCount"}, (Type[])new Type[]{Type.INTEGER}), (String)"assetCount"));
        projectionList.add(ProjectionFactoryUtil.property((String)"categoryId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"companyId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"createDate"));
        projectionList.add(ProjectionFactoryUtil.property((String)"description"));
        projectionList.add(ProjectionFactoryUtil.property((String)"groupId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"modifiedDate"));
        projectionList.add(ProjectionFactoryUtil.property((String)"name"));
        projectionList.add(ProjectionFactoryUtil.property((String)"userId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"vocabularyId"));
        return projectionList;
    }

    private long _getTotalCount(Long siteId) {
        DynamicQuery dynamicQuery = this._assetCategoryLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)this.contextCompany.getCompanyId()));
        if (siteId != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)siteId));
        }
        dynamicQuery.add(RestrictionsFactoryUtil.sqlRestriction((String)"exists (select 1 from AssetEntryAssetCategoryRel where assetCategoryId = this_.categoryId)"));
        return this._assetCategoryLocalService.dynamicQueryCount(dynamicQuery);
    }

    private String[] _merge(List<AssetCategoryProperty> assetCategoryProperties, TaxonomyCategoryProperty[] taxonomyCategoryProperties) {
        Stream<Object> stream = Arrays.stream((Object[])Optional.ofNullable(taxonomyCategoryProperties).orElse(new TaxonomyCategoryProperty[0]));
        Map<String, String> map = stream.collect(Collectors.toMap(TaxonomyCategoryProperty::getKey, TaxonomyCategoryProperty::getValue));
        for (AssetCategoryProperty assetCategoryProperty : assetCategoryProperties) {
            map.putIfAbsent(assetCategoryProperty.getKey(), assetCategoryProperty.getValue());
        }
        Set<Map.Entry<String, String>> entries = map.entrySet();
        Stream entriesStream = entries.stream();
        return (String[])entriesStream.map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).toArray(String[]::new);
    }

    private AssetCategory _toAssetCategory(final Object[] assetCategory) {
        return new AssetCategoryImpl(){
            {
                this.setCategoryId((Long)assetCategory[1]);
                this.setCompanyId((Long)assetCategory[2]);
                this.setCreateDate(TaxonomyCategoryResourceImpl.this._toDate((Timestamp)assetCategory[3]));
                this.setDescription((String)assetCategory[4]);
                this.setGroupId((Long)assetCategory[5]);
                this.setModifiedDate(TaxonomyCategoryResourceImpl.this._toDate((Timestamp)assetCategory[6]));
                this.setName((String)assetCategory[7]);
                this.setUserId((Long)assetCategory[8]);
                this.setVocabularyId((Long)assetCategory[9]);
            }
        };
    }

    private Date _toDate(Timestamp timestamp) {
        return new Date(timestamp.getTime());
    }

    private String[] _toStringArray(TaxonomyCategoryProperty[] taxonomyCategoryProperties) {
        return (String[])this.transform(taxonomyCategoryProperties, taxonomyCategoryProperty -> StringBundler.concat((String[])new String[]{taxonomyCategoryProperty.getKey(), ":", taxonomyCategoryProperty.getValue()}), String.class);
    }

    private TaxonomyCategory _toTaxonomyCategory(AssetCategory assetCategory) throws Exception {
        return this._taxonomyCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"add-category", this.addAction("ADD_CATEGORY", (GroupedModel)assetCategory, "postTaxonomyCategoryTaxonomyCategory")).put((Object)"delete", this.addAction("DELETE", (GroupedModel)assetCategory, "deleteTaxonomyCategory")).put((Object)"get", this.addAction("VIEW", (GroupedModel)assetCategory, "getTaxonomyCategory")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)assetCategory, "putTaxonomyCategory")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)assetCategory, "patchTaxonomyCategory")).build(), this._dtoConverterRegistry, (Object)assetCategory.getCategoryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), assetCategory);
    }

    private AssetCategory _updateAssetCategory(AssetCategory assetCategory, TaxonomyCategory taxonomyCategory) throws Exception {
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName(), (Map)taxonomyCategory.getName_i18n(), (Map)assetCategory.getTitleMap());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription(), (Map)taxonomyCategory.getDescription_i18n(), (Map)assetCategory.getDescriptionMap());
        LocalizedMapUtil.validateI18n((boolean)false, (Locale)LocaleUtil.fromLanguageId((String)assetCategory.getDefaultLanguageId()), (String)"Taxonomy category", (Map)titleMap, new HashSet(descriptionMap.keySet()));
        assetCategory.setTitleMap(titleMap);
        assetCategory.setDescriptionMap(descriptionMap);
        return this._assetCategoryService.updateCategory(assetCategory.getCategoryId(), assetCategory.getParentCategoryId(), titleMap, descriptionMap, assetCategory.getVocabularyId(), this._toStringArray(taxonomyCategory.getTaxonomyCategoryProperties()), ServiceContextRequestUtil.createServiceContext((long)assetCategory.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)taxonomyCategory.getViewableByAsString()));
    }
}

