/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.converter.KeywordDTOConverter;
import com.liferay.headless.admin.taxonomy.internal.odata.entity.v1_0.KeywordEntityModel;
import com.liferay.headless.admin.taxonomy.internal.resource.v1_0.BaseKeywordResourceImpl;
import com.liferay.headless.admin.taxonomy.resource.v1_0.KeywordResource;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portlet.asset.model.impl.AssetTagImpl;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/keyword.properties"}, scope=ServiceScope.PROTOTYPE, service={KeywordResource.class})
public class KeywordResourceImpl
extends BaseKeywordResourceImpl {
    private static final EntityModel _entityModel = new KeywordEntityModel();
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private KeywordDTOConverter _keywordDTOConverter;

    @Override
    public void deleteKeyword(Long keywordId) throws Exception {
        this._assetTagService.deleteTag(keywordId.longValue());
    }

    @Override
    public Page<Keyword> getAssetLibraryKeywordsPage(Long assetLibraryId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getKeywordsPage(HashMapBuilder.put((Object)"create", this.addAction("MANAGE_TAG", "postAssetLibraryKeyword", "com.liferay.asset.tags", assetLibraryId)).put((Object)"createBatch", this.addAction("MANAGE_TAG", "postAssetLibraryKeywordBatch", "com.liferay.asset.tags", assetLibraryId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteKeywordBatch", "com.liferay.asset.tags", null)).put((Object)"get", this.addAction("MANAGE_TAG", "getAssetLibraryKeywordsPage", "com.liferay.asset.tags", assetLibraryId)).put((Object)"updateBatch", this.addAction("UPDATE", "putKeywordBatch", "com.liferay.asset.tags", null)).build(), assetLibraryId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Keyword getKeyword(Long keywordId) throws Exception {
        return this._toKeyword(this._assetTagService.getTag(keywordId.longValue()));
    }

    @Override
    public Page<Keyword> getKeywordsRankedPage(Long siteId, String search, Pagination pagination) {
        DynamicQuery dynamicQuery = this._assetTagLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)this.contextCompany.getCompanyId()));
        if (siteId != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)siteId));
        }
        if (!Validator.isBlank((String)search)) {
            dynamicQuery.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)StringUtil.quote((String)search, (String)"%")));
        }
        dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"assetCount"));
        dynamicQuery.setProjection((Projection)this._getProjectionList(), true);
        return Page.of(this.transform(this.transform(this._assetTagLocalService.dynamicQuery(dynamicQuery, pagination.getStartPosition(), pagination.getEndPosition()), this::_toAssetTag), this::_toKeyword), (Pagination)pagination, (long)this._getTotalCount(search, siteId));
    }

    @Override
    public Page<Keyword> getSiteKeywordsPage(Long siteId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getKeywordsPage(HashMapBuilder.put((Object)"create", this.addAction("MANAGE_TAG", "postSiteKeyword", "com.liferay.asset.tags", siteId)).put((Object)"createBatch", this.addAction("MANAGE_TAG", "postSiteKeywordBatch", "com.liferay.asset.tags", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteKeywordBatch", "com.liferay.asset.tags", null)).put((Object)"get", this.addAction("MANAGE_TAG", "getSiteKeywordsPage", "com.liferay.asset.tags", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putKeywordBatch", "com.liferay.asset.tags", null)).build(), siteId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Keyword postAssetLibraryKeyword(Long assetLibraryId, Keyword keyword) throws Exception {
        return this.postSiteKeyword(assetLibraryId, keyword);
    }

    @Override
    public Keyword postSiteKeyword(Long siteId, Keyword keyword) throws Exception {
        return this._toKeyword(this._assetTagService.addTag(siteId.longValue(), keyword.getName(), new ServiceContext()));
    }

    @Override
    public Keyword putKeyword(Long keywordId, Keyword keyword) throws Exception {
        return this._toKeyword(this._assetTagService.updateTag(keywordId.longValue(), keyword.getName(), null));
    }

    @Override
    public void putKeywordSubscribe(Long tagId) throws Exception {
        AssetTag assetTag = this._assetTagLocalService.getAssetTag(tagId.longValue());
        this._assetTagService.subscribeTag(this.contextUser.getUserId(), assetTag.getGroupId(), tagId.longValue());
    }

    @Override
    public void putKeywordUnsubscribe(Long tagId) throws Exception {
        this._assetTagService.unsubscribeTag(this.contextUser.getUserId(), tagId.longValue());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        AssetTag assetTag = this._assetTagService.getTag(((Long)id).longValue());
        return assetTag.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.asset.tags";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return "com.liferay.asset.tags";
    }

    private Page<Keyword> _getKeywordsPage(Map<String, Map<String, String>> actions, Long groupId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQuery -> {}, (Filter)filter, (String)AssetTag.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("name", (Serializable)((Object)search));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
        }, (Sort[])sorts, document -> this._toKeyword(this._assetTagService.getTag(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private ProjectionList _getProjectionList() {
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(ProjectionFactoryUtil.alias((Projection)ProjectionFactoryUtil.sqlProjection((String)"COALESCE((select count(entryId) assetCount from AssetEntries_AssetTags where tagId = this_.tagId group by tagId), 0) AS assetCount", (String[])new String[]{"assetCount"}, (Type[])new Type[]{Type.INTEGER}), (String)"assetCount"));
        projectionList.add(ProjectionFactoryUtil.property((String)"companyId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"createDate"));
        projectionList.add(ProjectionFactoryUtil.property((String)"groupId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"modifiedDate"));
        projectionList.add(ProjectionFactoryUtil.property((String)"name"));
        projectionList.add(ProjectionFactoryUtil.property((String)"tagId"));
        projectionList.add(ProjectionFactoryUtil.property((String)"userId"));
        return projectionList;
    }

    private long _getTotalCount(String search, Long siteId) {
        DynamicQuery dynamicQuery = this._assetTagLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)this.contextCompany.getCompanyId()));
        if (!Validator.isBlank((String)search)) {
            dynamicQuery.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)StringUtil.quote((String)search, (String)"%")));
        }
        if (siteId != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)siteId));
        }
        return this._assetTagLocalService.dynamicQueryCount(dynamicQuery);
    }

    private AssetTag _toAssetTag(final Object[] assetTags) {
        return new AssetTagImpl(){
            {
                if (assetTags[0] != null) {
                    this.setAssetCount((Integer)assetTags[0]);
                }
                this.setCompanyId((Long)assetTags[1]);
                this.setCreateDate(KeywordResourceImpl.this._toDate((Timestamp)assetTags[2]));
                this.setGroupId((Long)assetTags[3]);
                this.setModifiedDate(KeywordResourceImpl.this._toDate((Timestamp)assetTags[4]));
                this.setName((String)assetTags[5]);
                this.setTagId((Long)assetTags[6]);
                this.setUserId((Long)assetTags[7]);
            }
        };
    }

    private Date _toDate(Timestamp timestamp) {
        return new Date(timestamp.getTime());
    }

    private Keyword _toKeyword(AssetTag assetTag) {
        return this._keywordDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("MANAGE_TAG", assetTag.getTagId(), "deleteKeyword", assetTag.getUserId(), "com.liferay.asset.tags", assetTag.getGroupId())).put((Object)"get", this.addAction("MANAGE_TAG", assetTag.getTagId(), "getKeyword", assetTag.getUserId(), "com.liferay.asset.tags", assetTag.getGroupId())).put((Object)"replace", this.addAction("MANAGE_TAG", assetTag.getTagId(), "putKeyword", assetTag.getUserId(), "com.liferay.asset.tags", assetTag.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", assetTag.getTagId(), "putKeywordSubscribe", assetTag.getUserId(), "com.liferay.asset.tags", assetTag.getGroupId())).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", assetTag.getTagId(), "putKeywordUnsubscribe", assetTag.getUserId(), "com.liferay.asset.tags", assetTag.getGroupId())).build(), this._dtoConverterRegistry, (Object)assetTag.getTagId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), assetTag);
    }
}

