/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseTaxonomyCategoryResourceImpl
implements EntityModelResource,
TaxonomyCategoryResource,
VulcanBatchEngineTaskItemDelegate<TaxonomyCategory> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<TaxonomyCategory>, UnsafeConsumer<TaxonomyCategory, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseTaxonomyCategoryResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @GET
    @Path(value="/taxonomy-categories/ranked")
    @Produces(value={"application/json", "application/xml"})
    public Page<TaxonomyCategory> getTaxonomyCategoriesRankedPage(@Parameter(hidden=true) @QueryParam(value="siteId") Long siteId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves a taxonomy category's child taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentTaxonomyCategoryId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @GET
    @Path(value="/taxonomy-categories/{parentTaxonomyCategoryId}/taxonomy-categories")
    @Produces(value={"application/json", "application/xml"})
    public Page<TaxonomyCategory> getTaxonomyCategoryTaxonomyCategoriesPage(@Parameter(hidden=true) @NotNull @PathParam(value="parentTaxonomyCategoryId") String parentTaxonomyCategoryId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Inserts a new child taxonomy category.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentTaxonomyCategoryId")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/taxonomy-categories/{parentTaxonomyCategoryId}/taxonomy-categories")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyCategory postTaxonomyCategoryTaxonomyCategory(@Parameter(hidden=true) @NotNull @PathParam(value="parentTaxonomyCategoryId") String parentTaxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    @Operation(description="Deletes the taxonomy category and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @DELETE
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteTaxonomyCategory(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/taxonomy-categories/batch")
    @Produces(value={"application/json"})
    public Response deleteTaxonomyCategoryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(TaxonomyCategory.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves a taxonomy category.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @GET
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyCategory getTaxonomyCategory(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId) throws Exception {
        return new TaxonomyCategory();
    }

    @Operation(description="Updates only the fields received in the request body. Other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyCategory patchTaxonomyCategory(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        TaxonomyCategory existingTaxonomyCategory = this.getTaxonomyCategory(taxonomyCategoryId);
        if (taxonomyCategory.getActions() != null) {
            existingTaxonomyCategory.setActions(taxonomyCategory.getActions());
        }
        if (taxonomyCategory.getAvailableLanguages() != null) {
            existingTaxonomyCategory.setAvailableLanguages(taxonomyCategory.getAvailableLanguages());
        }
        if (taxonomyCategory.getDateCreated() != null) {
            existingTaxonomyCategory.setDateCreated(taxonomyCategory.getDateCreated());
        }
        if (taxonomyCategory.getDateModified() != null) {
            existingTaxonomyCategory.setDateModified(taxonomyCategory.getDateModified());
        }
        if (taxonomyCategory.getDescription() != null) {
            existingTaxonomyCategory.setDescription(taxonomyCategory.getDescription());
        }
        if (taxonomyCategory.getDescription_i18n() != null) {
            existingTaxonomyCategory.setDescription_i18n(taxonomyCategory.getDescription_i18n());
        }
        if (taxonomyCategory.getExternalReferenceCode() != null) {
            existingTaxonomyCategory.setExternalReferenceCode(taxonomyCategory.getExternalReferenceCode());
        }
        if (taxonomyCategory.getName() != null) {
            existingTaxonomyCategory.setName(taxonomyCategory.getName());
        }
        if (taxonomyCategory.getName_i18n() != null) {
            existingTaxonomyCategory.setName_i18n(taxonomyCategory.getName_i18n());
        }
        if (taxonomyCategory.getNumberOfTaxonomyCategories() != null) {
            existingTaxonomyCategory.setNumberOfTaxonomyCategories(taxonomyCategory.getNumberOfTaxonomyCategories());
        }
        if (taxonomyCategory.getSiteId() != null) {
            existingTaxonomyCategory.setSiteId(taxonomyCategory.getSiteId());
        }
        if (taxonomyCategory.getTaxonomyCategoryUsageCount() != null) {
            existingTaxonomyCategory.setTaxonomyCategoryUsageCount(taxonomyCategory.getTaxonomyCategoryUsageCount());
        }
        if (taxonomyCategory.getTaxonomyVocabularyId() != null) {
            existingTaxonomyCategory.setTaxonomyVocabularyId(taxonomyCategory.getTaxonomyVocabularyId());
        }
        if (taxonomyCategory.getViewableBy() != null) {
            existingTaxonomyCategory.setViewableBy(taxonomyCategory.getViewableBy());
        }
        this.preparePatch(taxonomyCategory, existingTaxonomyCategory);
        return this.putTaxonomyCategory(taxonomyCategoryId, existingTaxonomyCategory);
    }

    @Operation(description="Replaces the taxonomy category with the information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public TaxonomyCategory putTaxonomyCategory(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json"})
    @Path(value="/taxonomy-categories/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putTaxonomyCategoryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(TaxonomyCategory.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @GET
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getTaxonomyCategoryPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(taxonomyCategoryId);
        Long resourceId = this.getPermissionCheckerResourceId(taxonomyCategoryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(taxonomyCategoryId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getTaxonomyCategoryPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putTaxonomyCategoryPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putTaxonomyCategoryPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(taxonomyCategoryId);
        Long resourceId = this.getPermissionCheckerResourceId(taxonomyCategoryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(taxonomyCategoryId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(taxonomyCategoryId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getTaxonomyCategoryPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putTaxonomyCategoryPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Operation(description="Retrieves a vocabulary's taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @GET
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories")
    @Produces(value={"application/json", "application/xml"})
    public Page<TaxonomyCategory> getTaxonomyVocabularyTaxonomyCategoriesPage(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Inserts a new taxonomy category in a taxonomy vocabulary.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyCategory postTaxonomyVocabularyTaxonomyCategory(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json"})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postTaxonomyVocabularyTaxonomyCategoryBatch(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(TaxonomyCategory.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the site's taxonomy category by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @DELETE
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves the site's taxonomy category by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @GET
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyCategory getTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new TaxonomyCategory();
    }

    @Operation(description="Updates the site's taxonomy category with the given external reference code, or creates it if it not exists.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public TaxonomyCategory putTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    public void create(Collection<TaxonomyCategory> taxonomyCategories, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer taxonomyCategoryUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("taxonomyVocabularyId")) {
                taxonomyCategoryUnsafeConsumer = taxonomyCategory -> this.postTaxonomyVocabularyTaxonomyCategory(Long.parseLong((String)parameters.get("taxonomyVocabularyId")), (TaxonomyCategory)taxonomyCategory);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [taxonomyVocabularyId]");
            }
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            taxonomyCategoryUnsafeConsumer = taxonomyCategory -> this.putTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(taxonomyCategory.getTaxonomyVocabularyId() != null ? taxonomyCategory.getTaxonomyVocabularyId() : Long.parseLong((String)parameters.get("taxonomyVocabularyId")), taxonomyCategory.getExternalReferenceCode(), (TaxonomyCategory)taxonomyCategory);
        }
        if (taxonomyCategoryUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for TaxonomyCategory");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(taxonomyCategories, (Object)taxonomyCategoryUnsafeConsumer);
        } else {
            for (TaxonomyCategory taxonomyCategory2 : taxonomyCategories) {
                taxonomyCategoryUnsafeConsumer.accept((Object)taxonomyCategory2);
            }
        }
    }

    public void delete(Collection<TaxonomyCategory> taxonomyCategories, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyCategory taxonomyCategory : taxonomyCategories) {
            this.deleteTaxonomyCategory(taxonomyCategory.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<TaxonomyCategory> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<TaxonomyCategory> taxonomyCategories, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer taxonomyCategoryUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            taxonomyCategoryUnsafeConsumer = taxonomyCategory -> this.patchTaxonomyCategory(taxonomyCategory.getId() != null ? taxonomyCategory.getId() : (String)parameters.get("taxonomyCategoryId"), (TaxonomyCategory)taxonomyCategory);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            taxonomyCategoryUnsafeConsumer = taxonomyCategory -> this.putTaxonomyCategory(taxonomyCategory.getId() != null ? taxonomyCategory.getId() : (String)parameters.get("taxonomyCategoryId"), (TaxonomyCategory)taxonomyCategory);
        }
        if (taxonomyCategoryUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for TaxonomyCategory");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(taxonomyCategories, (Object)taxonomyCategoryUnsafeConsumer);
        } else {
            for (TaxonomyCategory taxonomyCategory2 : taxonomyCategories) {
                taxonomyCategoryUnsafeConsumer.accept((Object)taxonomyCategory2);
            }
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<TaxonomyCategory>, UnsafeConsumer<TaxonomyCategory, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(TaxonomyCategory taxonomyCategory, TaxonomyCategory existingTaxonomyCategory) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

