/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.graphql.query.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.KeywordResource;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<KeywordResource> _keywordResourceComponentServiceObjects;
    private static ComponentServiceObjects<TaxonomyCategoryResource> _taxonomyCategoryResourceComponentServiceObjects;
    private static ComponentServiceObjects<TaxonomyVocabularyResource> _taxonomyVocabularyResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private BiFunction<Object, List<String>, Aggregation> _aggregationBiFunction;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setKeywordResourceComponentServiceObjects(ComponentServiceObjects<KeywordResource> keywordResourceComponentServiceObjects) {
        _keywordResourceComponentServiceObjects = keywordResourceComponentServiceObjects;
    }

    public static void setTaxonomyCategoryResourceComponentServiceObjects(ComponentServiceObjects<TaxonomyCategoryResource> taxonomyCategoryResourceComponentServiceObjects) {
        _taxonomyCategoryResourceComponentServiceObjects = taxonomyCategoryResourceComponentServiceObjects;
    }

    public static void setTaxonomyVocabularyResourceComponentServiceObjects(ComponentServiceObjects<TaxonomyVocabularyResource> taxonomyVocabularyResourceComponentServiceObjects) {
        _taxonomyVocabularyResourceComponentServiceObjects = taxonomyVocabularyResourceComponentServiceObjects;
    }

    @GraphQLField
    public KeywordPage assetLibraryKeywords(@GraphQLName(value="assetLibraryId") @NotEmpty String assetLibraryId, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (KeywordPage)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> new KeywordPage(keywordResource.getAssetLibraryKeywordsPage(Long.valueOf(assetLibraryId), search, this._aggregationBiFunction.apply(keywordResource, aggregations), this._filterBiFunction.apply(keywordResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(keywordResource, sortsString))));
    }

    @GraphQLField
    public KeywordPage assetLibraryKeywordPermissions(@GraphQLName(value="assetLibraryId") @NotEmpty String assetLibraryId, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (KeywordPage)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> new KeywordPage(keywordResource.getAssetLibraryKeywordPermissionsPage(Long.valueOf(assetLibraryId), roleNames)));
    }

    @GraphQLField
    public KeywordPage keywordsRanked(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="search") String search, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (KeywordPage)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> new KeywordPage(keywordResource.getKeywordsRankedPage(Long.valueOf(siteKey), search, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves a keyword.")
    public @GraphQLField(description="Retrieves a keyword.") Keyword keyword(@GraphQLName(value="keywordId") Long keywordId) throws Exception {
        return (Keyword)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.getKeyword(keywordId));
    }

    @GraphQLField(description="Retrieves a Site's keywords. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves a Site's keywords. Results can be paginated, filtered, searched, and sorted.") KeywordPage keywords(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (KeywordPage)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> new KeywordPage(keywordResource.getSiteKeywordsPage(Long.valueOf(siteKey), search, this._aggregationBiFunction.apply(keywordResource, aggregations), this._filterBiFunction.apply(keywordResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(keywordResource, sortsString))));
    }

    @GraphQLField
    public KeywordPage keywordPermissions(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (KeywordPage)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> new KeywordPage(keywordResource.getSiteKeywordPermissionsPage(Long.valueOf(siteKey), roleNames)));
    }

    @GraphQLField
    public TaxonomyCategoryPage taxonomyCategoriesRanked(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (TaxonomyCategoryPage)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyCategoriesRankedPage(Long.valueOf(siteKey), Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves a taxonomy category's child taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves a taxonomy category's child taxonomy categories. Results can be paginated, filtered, searched, and sorted.") TaxonomyCategoryPage taxonomyCategoryTaxonomyCategories(@GraphQLName(value="parentTaxonomyCategoryId") String parentTaxonomyCategoryId, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (TaxonomyCategoryPage)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyCategoryTaxonomyCategoriesPage(parentTaxonomyCategoryId, search, this._aggregationBiFunction.apply(taxonomyCategoryResource, aggregations), this._filterBiFunction.apply(taxonomyCategoryResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(taxonomyCategoryResource, sortsString))));
    }

    @GraphQLField(description="Retrieves a taxonomy category.")
    public @GraphQLField(description="Retrieves a taxonomy category.") TaxonomyCategory taxonomyCategory(@GraphQLName(value="taxonomyCategoryId") String taxonomyCategoryId) throws Exception {
        return (TaxonomyCategory)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.getTaxonomyCategory(taxonomyCategoryId));
    }

    @GraphQLField
    public TaxonomyCategoryPage taxonomyCategoryPermissions(@GraphQLName(value="taxonomyCategoryId") String taxonomyCategoryId, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (TaxonomyCategoryPage)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyCategoryPermissionsPage(taxonomyCategoryId, roleNames)));
    }

    @GraphQLField(description="Retrieves a vocabulary's taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves a vocabulary's taxonomy categories. Results can be paginated, filtered, searched, and sorted.") TaxonomyCategoryPage taxonomyVocabularyTaxonomyCategories(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (TaxonomyCategoryPage)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyVocabularyTaxonomyCategoriesPage(taxonomyVocabularyId, search, this._aggregationBiFunction.apply(taxonomyCategoryResource, aggregations), this._filterBiFunction.apply(taxonomyCategoryResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(taxonomyCategoryResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the site's taxonomy category by external reference code.")
    public @GraphQLField(description="Retrieves the site's taxonomy category by external reference code.") TaxonomyCategory taxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (TaxonomyCategory)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.getTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(taxonomyVocabularyId, externalReferenceCode));
    }

    @GraphQLField
    public TaxonomyVocabularyPage assetLibraryTaxonomyVocabularies(@GraphQLName(value="assetLibraryId") @NotEmpty String assetLibraryId, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (TaxonomyVocabularyPage)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> new TaxonomyVocabularyPage(taxonomyVocabularyResource.getAssetLibraryTaxonomyVocabulariesPage(Long.valueOf(assetLibraryId), search, this._aggregationBiFunction.apply(taxonomyVocabularyResource, aggregations), this._filterBiFunction.apply(taxonomyVocabularyResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(taxonomyVocabularyResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the asset library's taxonomy vocabulary by external reference code.")
    public @GraphQLField(description="Retrieves the asset library's taxonomy vocabulary by external reference code.") TaxonomyVocabulary assetLibraryTaxonomyVocabularyByExternalReferenceCode(@GraphQLName(value="assetLibraryId") @NotEmpty String assetLibraryId, @GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (TaxonomyVocabulary)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.getAssetLibraryTaxonomyVocabularyByExternalReferenceCode(Long.valueOf(assetLibraryId), externalReferenceCode));
    }

    @GraphQLField
    public TaxonomyVocabularyPage assetLibraryTaxonomyVocabularyPermissions(@GraphQLName(value="assetLibraryId") @NotEmpty String assetLibraryId, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (TaxonomyVocabularyPage)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> new TaxonomyVocabularyPage(taxonomyVocabularyResource.getAssetLibraryTaxonomyVocabularyPermissionsPage(Long.valueOf(assetLibraryId), roleNames)));
    }

    @GraphQLField(description="Retrieves a Site's taxonomy vocabularies. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves a Site's taxonomy vocabularies. Results can be paginated, filtered, searched, and sorted.") TaxonomyVocabularyPage taxonomyVocabularies(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (TaxonomyVocabularyPage)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> new TaxonomyVocabularyPage(taxonomyVocabularyResource.getSiteTaxonomyVocabulariesPage(Long.valueOf(siteKey), search, this._aggregationBiFunction.apply(taxonomyVocabularyResource, aggregations), this._filterBiFunction.apply(taxonomyVocabularyResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(taxonomyVocabularyResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the site's taxonomy vocabulary by external reference code.")
    public @GraphQLField(description="Retrieves the site's taxonomy vocabulary by external reference code.") TaxonomyVocabulary taxonomyVocabularyByExternalReferenceCode(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (TaxonomyVocabulary)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.getSiteTaxonomyVocabularyByExternalReferenceCode(Long.valueOf(siteKey), externalReferenceCode));
    }

    @GraphQLField
    public TaxonomyVocabularyPage siteTaxonomyVocabularyPermissions(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (TaxonomyVocabularyPage)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> new TaxonomyVocabularyPage(taxonomyVocabularyResource.getSiteTaxonomyVocabularyPermissionsPage(Long.valueOf(siteKey), roleNames)));
    }

    @GraphQLField(description="Retrieves a taxonomy vocabulary.")
    public @GraphQLField(description="Retrieves a taxonomy vocabulary.") TaxonomyVocabulary taxonomyVocabulary(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
        return (TaxonomyVocabulary)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.getTaxonomyVocabulary(taxonomyVocabularyId));
    }

    @GraphQLField
    public TaxonomyVocabularyPage taxonomyVocabularyPermissions(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="roleNames") String roleNames) throws Exception {
        return (TaxonomyVocabularyPage)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> new TaxonomyVocabularyPage(taxonomyVocabularyResource.getTaxonomyVocabularyPermissionsPage(taxonomyVocabularyId, roleNames)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(KeywordResource keywordResource) throws Exception {
        keywordResource.setContextAcceptLanguage(this._acceptLanguage);
        keywordResource.setContextCompany(this._company);
        keywordResource.setContextHttpServletRequest(this._httpServletRequest);
        keywordResource.setContextHttpServletResponse(this._httpServletResponse);
        keywordResource.setContextUriInfo(this._uriInfo);
        keywordResource.setContextUser(this._user);
        keywordResource.setGroupLocalService(this._groupLocalService);
        keywordResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(TaxonomyCategoryResource taxonomyCategoryResource) throws Exception {
        taxonomyCategoryResource.setContextAcceptLanguage(this._acceptLanguage);
        taxonomyCategoryResource.setContextCompany(this._company);
        taxonomyCategoryResource.setContextHttpServletRequest(this._httpServletRequest);
        taxonomyCategoryResource.setContextHttpServletResponse(this._httpServletResponse);
        taxonomyCategoryResource.setContextUriInfo(this._uriInfo);
        taxonomyCategoryResource.setContextUser(this._user);
        taxonomyCategoryResource.setGroupLocalService(this._groupLocalService);
        taxonomyCategoryResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(TaxonomyVocabularyResource taxonomyVocabularyResource) throws Exception {
        taxonomyVocabularyResource.setContextAcceptLanguage(this._acceptLanguage);
        taxonomyVocabularyResource.setContextCompany(this._company);
        taxonomyVocabularyResource.setContextHttpServletRequest(this._httpServletRequest);
        taxonomyVocabularyResource.setContextHttpServletResponse(this._httpServletResponse);
        taxonomyVocabularyResource.setContextUriInfo(this._uriInfo);
        taxonomyVocabularyResource.setContextUser(this._user);
        taxonomyVocabularyResource.setGroupLocalService(this._groupLocalService);
        taxonomyVocabularyResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="TaxonomyVocabularyPage")
    public class TaxonomyVocabularyPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<TaxonomyVocabulary> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public TaxonomyVocabularyPage(Page taxonomyVocabularyPage) {
            this.actions = taxonomyVocabularyPage.getActions();
            this.facets = taxonomyVocabularyPage.getFacets();
            this.items = taxonomyVocabularyPage.getItems();
            this.lastPage = taxonomyVocabularyPage.getLastPage();
            this.page = taxonomyVocabularyPage.getPage();
            this.pageSize = taxonomyVocabularyPage.getPageSize();
            this.totalCount = taxonomyVocabularyPage.getTotalCount();
        }
    }

    @GraphQLName(value="TaxonomyCategoryPage")
    public class TaxonomyCategoryPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<TaxonomyCategory> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public TaxonomyCategoryPage(Page taxonomyCategoryPage) {
            this.actions = taxonomyCategoryPage.getActions();
            this.facets = taxonomyCategoryPage.getFacets();
            this.items = taxonomyCategoryPage.getItems();
            this.lastPage = taxonomyCategoryPage.getLastPage();
            this.page = taxonomyCategoryPage.getPage();
            this.pageSize = taxonomyCategoryPage.getPageSize();
            this.totalCount = taxonomyCategoryPage.getTotalCount();
        }
    }

    @GraphQLName(value="KeywordPage")
    public class KeywordPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<Keyword> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public KeywordPage(Page keywordPage) {
            this.actions = keywordPage.getActions();
            this.facets = keywordPage.getFacets();
            this.items = keywordPage.getItems();
            this.lastPage = keywordPage.getLastPage();
            this.page = keywordPage.getPage();
            this.pageSize = keywordPage.getPageSize();
            this.totalCount = keywordPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=TaxonomyVocabulary.class)
    public class GetTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCodeTypeExtension {
        private TaxonomyVocabulary _taxonomyVocabulary;

        public GetTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCodeTypeExtension(TaxonomyVocabulary taxonomyVocabulary) {
            this._taxonomyVocabulary = taxonomyVocabulary;
        }

        @GraphQLField(description="Retrieves the site's taxonomy category by external reference code.")
        public @GraphQLField(description="Retrieves the site's taxonomy category by external reference code.") TaxonomyCategory taxonomyCategoryByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
            return (TaxonomyCategory)Query.this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), taxonomyCategoryResource -> taxonomyCategoryResource.getTaxonomyVocabularyTaxonomyCategoryByExternalReferenceCode(this._taxonomyVocabulary.getId(), externalReferenceCode));
        }
    }

    @GraphQLTypeExtension(value=TaxonomyCategory.class)
    public class GetTaxonomyVocabularyTypeExtension {
        private TaxonomyCategory _taxonomyCategory;

        public GetTaxonomyVocabularyTypeExtension(TaxonomyCategory taxonomyCategory) {
            this._taxonomyCategory = taxonomyCategory;
        }

        @GraphQLField(description="Retrieves a taxonomy vocabulary.")
        public @GraphQLField(description="Retrieves a taxonomy vocabulary.") TaxonomyVocabulary taxonomyVocabulary() throws Exception {
            return (TaxonomyVocabulary)Query.this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), taxonomyVocabularyResource -> taxonomyVocabularyResource.getTaxonomyVocabulary(this._taxonomyCategory.getTaxonomyVocabularyId()));
        }
    }

    @GraphQLTypeExtension(value=TaxonomyCategory.class)
    public class GetTaxonomyCategoryTaxonomyCategoriesPageTypeExtension {
        private TaxonomyCategory _taxonomyCategory;

        public GetTaxonomyCategoryTaxonomyCategoriesPageTypeExtension(TaxonomyCategory taxonomyCategory) {
            this._taxonomyCategory = taxonomyCategory;
        }

        @GraphQLField(description="Retrieves a taxonomy category's child taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves a taxonomy category's child taxonomy categories. Results can be paginated, filtered, searched, and sorted.") TaxonomyCategoryPage taxonomyCategories(@GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (TaxonomyCategoryPage)Query.this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyCategoryTaxonomyCategoriesPage(this._taxonomyCategory.getId(), search, (Aggregation)Query.this._aggregationBiFunction.apply(taxonomyCategoryResource, aggregations), (Filter)Query.this._filterBiFunction.apply(taxonomyCategoryResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(taxonomyCategoryResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=TaxonomyVocabulary.class)
    public class GetTaxonomyVocabularyTaxonomyCategoriesPageTypeExtension {
        private TaxonomyVocabulary _taxonomyVocabulary;

        public GetTaxonomyVocabularyTaxonomyCategoriesPageTypeExtension(TaxonomyVocabulary taxonomyVocabulary) {
            this._taxonomyVocabulary = taxonomyVocabulary;
        }

        @GraphQLField(description="Retrieves a vocabulary's taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves a vocabulary's taxonomy categories. Results can be paginated, filtered, searched, and sorted.") TaxonomyCategoryPage taxonomyCategories(@GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (TaxonomyCategoryPage)Query.this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyVocabularyTaxonomyCategoriesPage(this._taxonomyVocabulary.getId(), search, (Aggregation)Query.this._aggregationBiFunction.apply(taxonomyCategoryResource, aggregations), (Filter)Query.this._filterBiFunction.apply(taxonomyCategoryResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(taxonomyCategoryResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=TaxonomyVocabulary.class)
    public class GetTaxonomyVocabularyPermissionsPageTypeExtension {
        private TaxonomyVocabulary _taxonomyVocabulary;

        public GetTaxonomyVocabularyPermissionsPageTypeExtension(TaxonomyVocabulary taxonomyVocabulary) {
            this._taxonomyVocabulary = taxonomyVocabulary;
        }

        @GraphQLField
        public TaxonomyVocabularyPage permissions(@GraphQLName(value="roleNames") String roleNames) throws Exception {
            return (TaxonomyVocabularyPage)Query.this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), taxonomyVocabularyResource -> new TaxonomyVocabularyPage(taxonomyVocabularyResource.getTaxonomyVocabularyPermissionsPage(this._taxonomyVocabulary.getId(), roleNames)));
        }
    }

    @GraphQLTypeExtension(value=TaxonomyCategory.class)
    public class GetTaxonomyCategoryPermissionsPageTypeExtension {
        private TaxonomyCategory _taxonomyCategory;

        public GetTaxonomyCategoryPermissionsPageTypeExtension(TaxonomyCategory taxonomyCategory) {
            this._taxonomyCategory = taxonomyCategory;
        }

        @GraphQLField
        public TaxonomyCategoryPage permissions(@GraphQLName(value="roleNames") String roleNames) throws Exception {
            return (TaxonomyCategoryPage)Query.this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), taxonomyCategoryResource -> new TaxonomyCategoryPage(taxonomyCategoryResource.getTaxonomyCategoryPermissionsPage(this._taxonomyCategory.getId(), roleNames)));
        }
    }
}

