/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.asset.kernel.model.AssetTag"}, service={DTOConverter.class, KeywordDTOConverter.class})
public class KeywordDTOConverter
implements DTOConverter<AssetTag, Keyword> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Keyword.class.getSimpleName();
    }

    public Keyword toDTO(final DTOConverterContext dtoConverterContext, final AssetTag assetTag) {
        final Group group = this._groupLocalService.fetchGroup(assetTag.getGroupId());
        return new Keyword(){
            {
                this.actions = dtoConverterContext.getActions();
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.dateCreated = assetTag.getCreateDate();
                this.dateModified = assetTag.getModifiedDate();
                this.id = assetTag.getTagId();
                this.name = assetTag.getName();
                this.siteId = GroupUtil.getSiteId((Group)group);
                this.subscribed = KeywordDTOConverter.this._subscriptionLocalService.isSubscribed(assetTag.getCompanyId(), dtoConverterContext.getUserId(), AssetTag.class.getName(), assetTag.getTagId());
                this.setCreator(() -> {
                    if (assetTag.getUserId() != 0L) {
                        return CreatorUtil.toCreator(KeywordDTOConverter.this._portal, KeywordDTOConverter.this._userLocalService.fetchUser(assetTag.getUserId()));
                    }
                    return null;
                });
                this.setKeywordUsageCount(() -> {
                    Hits hits = KeywordDTOConverter.this._assetEntryLocalService.search(assetTag.getCompanyId(), new long[]{assetTag.getGroupId()}, assetTag.getUserId(), null, -1L, null, null, null, null, assetTag.getName(), true, new int[]{0, 1, 7}, false, 0, 1);
                    return hits.getLength();
                });
            }
        };
    }
}

