/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.ParentTaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.ParentTaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.taxonomy.internal.odata.entity.v1_0.CategoryEntityModel;
import com.liferay.headless.admin.taxonomy.internal.resource.v1_0.BaseTaxonomyCategoryResourceImpl;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ContentLanguageUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/taxonomy-category.properties"}, scope=ServiceScope.PROTOTYPE, service={TaxonomyCategoryResource.class})
public class TaxonomyCategoryResourceImpl
extends BaseTaxonomyCategoryResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new CategoryEntityModel();
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteTaxonomyCategory(Long taxonomyCategoryId) throws Exception {
        this._assetCategoryService.deleteCategory(taxonomyCategoryId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public TaxonomyCategory getTaxonomyCategory(Long taxonomyCategoryId) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(taxonomyCategoryId.longValue());
        ContentLanguageUtil.addContentLanguageHeader((String[])assetCategory.getAvailableLanguageIds(), (String)assetCategory.getDefaultLanguageId(), (HttpServletResponse)this.contextHttpServletResponse, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        return this._toTaxonomyCategory(assetCategory);
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyCategoryTaxonomyCategoriesPage(Long parentTaxonomyCategoryId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getCategoriesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (parentTaxonomyCategoryId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(parentTaxonomyCategoryId)), BooleanClauseOccur.MUST);
            }
        }), search, filter, pagination, sorts);
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyVocabularyTaxonomyCategoriesPage(Long taxonomyVocabularyId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getCategoriesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (taxonomyVocabularyId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(0L)), BooleanClauseOccur.MUST);
                booleanFilter.add((Filter)new TermFilter("assetVocabularyId", String.valueOf(taxonomyVocabularyId)), BooleanClauseOccur.MUST);
            }
        }), search, filter, pagination, sorts);
    }

    @Override
    public TaxonomyCategory patchTaxonomyCategory(Long taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(taxonomyCategoryId.longValue());
        if (!ArrayUtil.contains((Object[])assetCategory.getAvailableLanguageIds(), (Object)this.contextAcceptLanguage.getPreferredLanguageId())) {
            throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to patch taxonomy category with language ", LocaleUtil.toW3cLanguageId((String)this.contextAcceptLanguage.getPreferredLanguageId()), " because it is only available in the following languages ", LocaleUtil.toW3cLanguageIds((String[])assetCategory.getAvailableLanguageIds())}));
        }
        return this._toTaxonomyCategory(this._assetCategoryService.updateCategory(taxonomyCategoryId.longValue(), assetCategory.getParentCategoryId(), LocalizedMapUtil.patch((Map)assetCategory.getTitleMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName()), LocalizedMapUtil.patch((Map)assetCategory.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription()), assetCategory.getVocabularyId(), null, new ServiceContext()));
    }

    @Override
    public TaxonomyCategory postTaxonomyCategoryTaxonomyCategory(Long parentTaxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(parentTaxonomyCategoryId.longValue());
        return this._addTaxonomyCategory(assetCategory.getGroupId(), assetCategory.getDefaultLanguageId(), taxonomyCategory, assetCategory.getCategoryId(), assetCategory.getVocabularyId());
    }

    @Override
    public TaxonomyCategory postTaxonomyVocabularyTaxonomyCategory(Long taxonomyVocabularyId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        return this._addTaxonomyCategory(assetVocabulary.getGroupId(), assetVocabulary.getDefaultLanguageId(), taxonomyCategory, 0L, assetVocabulary.getVocabularyId());
    }

    @Override
    public TaxonomyCategory putTaxonomyCategory(Long taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(taxonomyCategoryId.longValue());
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName(), (Map)taxonomyCategory.getName_i18n(), (Map)assetCategory.getTitleMap());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription(), (Map)taxonomyCategory.getDescription_i18n(), (Map)assetCategory.getDescriptionMap());
        LocalizedMapUtil.validateI18n((boolean)false, (Locale)LocaleUtil.fromLanguageId((String)assetCategory.getDefaultLanguageId()), (String)"Taxonomy category", (Map)titleMap, new HashSet(descriptionMap.keySet()));
        assetCategory.setTitleMap(titleMap);
        assetCategory.setDescriptionMap(descriptionMap);
        AssetCategoryPermission.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long)assetCategory.getCategoryId(), (String)"UPDATE");
        return this._toTaxonomyCategory(this._assetCategoryService.updateCategory(taxonomyCategoryId.longValue(), assetCategory.getParentCategoryId(), titleMap, descriptionMap, assetCategory.getVocabularyId(), null, new ServiceContext()));
    }

    private TaxonomyCategory _addTaxonomyCategory(long groupId, String languageId, TaxonomyCategory taxonomyCategory, long taxonomyCategoryId, long taxonomyVocabularyId) throws Exception {
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName(), (Map)taxonomyCategory.getName_i18n());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription(), (Map)taxonomyCategory.getDescription_i18n());
        LocalizedMapUtil.validateI18n((boolean)true, (Locale)LocaleUtil.fromLanguageId((String)languageId), (String)"Taxonomy category", (Map)titleMap, new HashSet(descriptionMap.keySet()));
        AssetCategory assetCategory = this._assetCategoryService.addCategory(groupId, taxonomyCategoryId, titleMap, descriptionMap, taxonomyVocabularyId, null, ServiceContextUtil.createServiceContext((long)groupId, (String)taxonomyCategory.getViewableByAsString()));
        return this._toTaxonomyCategory(assetCategory);
    }

    private Page<TaxonomyCategory> _getCategoriesPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, AssetCategory.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"assetCategoryId"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toTaxonomyCategory(this._assetCategoryService.getCategory(GetterUtil.getLong((String)document.get("assetCategoryId")))), (Sort[])sorts);
    }

    private ParentTaxonomyCategory _toParentTaxonomyCategory(final AssetCategory parentAssetCategory) {
        return new ParentTaxonomyCategory(){
            {
                this.id = parentAssetCategory.getCategoryId();
                this.name = parentAssetCategory.getTitle(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
            }
        };
    }

    private TaxonomyCategory _toTaxonomyCategory(final AssetCategory assetCategory) throws Exception {
        return new TaxonomyCategory(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])assetCategory.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(TaxonomyCategoryResourceImpl.this._portal, TaxonomyCategoryResourceImpl.this._userLocalService.getUserById(assetCategory.getUserId()));
                this.dateCreated = assetCategory.getCreateDate();
                this.dateModified = assetCategory.getModifiedDate();
                this.description = assetCategory.getDescription(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)assetCategory.getDescriptionMap());
                this.id = assetCategory.getCategoryId();
                this.name = assetCategory.getTitle(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)assetCategory.getTitleMap());
                this.numberOfTaxonomyCategories = TaxonomyCategoryResourceImpl.this._assetCategoryService.getChildCategoriesCount(assetCategory.getCategoryId());
                this.parentTaxonomyVocabulary = new ParentTaxonomyVocabulary(){
                    {
                        this.id = assetCategory.getVocabularyId();
                        this.setName(() -> {
                            AssetVocabulary assetVocabulary = TaxonomyCategoryResourceImpl.this._assetVocabularyService.getVocabulary(assetCategory.getVocabularyId());
                            return assetVocabulary.getTitle(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                        });
                    }
                };
                this.setParentTaxonomyCategory(() -> {
                    if (assetCategory.getParentCategory() == null) {
                        return null;
                    }
                    return TaxonomyCategoryResourceImpl.this._toParentTaxonomyCategory(assetCategory.getParentCategory());
                });
            }
        };
    }
}

