/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.taxonomy.internal.odata.entity.v1_0.KeywordEntityModel;
import com.liferay.headless.admin.taxonomy.internal.resource.v1_0.BaseKeywordResourceImpl;
import com.liferay.headless.admin.taxonomy.resource.v1_0.KeywordResource;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/keyword.properties"}, scope=ServiceScope.PROTOTYPE, service={KeywordResource.class})
public class KeywordResourceImpl
extends BaseKeywordResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new KeywordEntityModel();
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteKeyword(Long keywordId) throws Exception {
        this._assetTagService.deleteTag(keywordId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Keyword getKeyword(Long keywordId) throws Exception {
        return this._toKeyword(this._assetTagService.getTag(keywordId.longValue()));
    }

    @Override
    public Page<Keyword> getSiteKeywordsPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {}, (Filter)filter, AssetTag.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toKeyword(this._assetTagService.getTag(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public Keyword postSiteKeyword(Long siteId, Keyword keyword) throws Exception {
        return this._toKeyword(this._assetTagService.addTag(siteId.longValue(), keyword.getName(), new ServiceContext()));
    }

    @Override
    public Keyword putKeyword(Long keywordId, Keyword keyword) throws Exception {
        return this._toKeyword(this._assetTagService.updateTag(keywordId.longValue(), keyword.getName(), null));
    }

    private Keyword _toKeyword(final AssetTag assetTag) {
        return new Keyword(){
            {
                this.dateCreated = assetTag.getCreateDate();
                this.dateModified = assetTag.getModifiedDate();
                this.id = assetTag.getTagId();
                this.name = assetTag.getName();
                this.siteId = assetTag.getGroupId();
                this.setCreator(() -> {
                    if (assetTag.getUserId() != 0L) {
                        return CreatorUtil.toCreator(KeywordResourceImpl.this._portal, KeywordResourceImpl.this._userLocalService.fetchUser(assetTag.getUserId()));
                    }
                    return null;
                });
                this.setKeywordUsageCount(() -> {
                    Hits hits = KeywordResourceImpl.this._assetEntryLocalService.search(assetTag.getCompanyId(), new long[]{assetTag.getGroupId()}, assetTag.getUserId(), null, 0L, null, null, null, null, assetTag.getName(), true, new int[]{0, 1, 7}, false, 0, 1);
                    return hits.getLength();
                });
            }
        };
    }
}

