/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseTaxonomyVocabularyResourceImpl
implements EntityModelResource,
TaxonomyVocabularyResource,
VulcanBatchEngineTaskItemDelegate<TaxonomyVocabulary> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<TaxonomyVocabulary>, UnsafeConsumer<TaxonomyVocabulary, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseTaxonomyVocabularyResourceImpl.class);

    @Operation(description="Retrieves a Site's taxonomy vocabularies. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @GET
    @Path(value="/sites/{siteId}/taxonomy-vocabularies")
    @Produces(value={"application/json", "application/xml"})
    public Page<TaxonomyVocabulary> getSiteTaxonomyVocabulariesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Inserts a new taxonomy vocabulary in a Site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyVocabulary postSiteTaxonomyVocabulary(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteTaxonomyVocabularyBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(TaxonomyVocabulary.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the taxonomy vocabulary and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @DELETE
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteTaxonomyVocabulary(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/taxonomy-vocabularies/batch")
    @Produces(value={"application/json"})
    public Response deleteTaxonomyVocabularyBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(TaxonomyVocabulary.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves a taxonomy vocabulary.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @GET
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyVocabulary getTaxonomyVocabulary(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Operation(description="Updates only the fields received in the request body. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    public TaxonomyVocabulary patchTaxonomyVocabulary(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        TaxonomyVocabulary existingTaxonomyVocabulary = this.getTaxonomyVocabulary(taxonomyVocabularyId);
        if (taxonomyVocabulary.getAvailableLanguages() != null) {
            existingTaxonomyVocabulary.setAvailableLanguages(taxonomyVocabulary.getAvailableLanguages());
        }
        if (taxonomyVocabulary.getDateCreated() != null) {
            existingTaxonomyVocabulary.setDateCreated(taxonomyVocabulary.getDateCreated());
        }
        if (taxonomyVocabulary.getDateModified() != null) {
            existingTaxonomyVocabulary.setDateModified(taxonomyVocabulary.getDateModified());
        }
        if (taxonomyVocabulary.getDescription() != null) {
            existingTaxonomyVocabulary.setDescription(taxonomyVocabulary.getDescription());
        }
        if (taxonomyVocabulary.getDescription_i18n() != null) {
            existingTaxonomyVocabulary.setDescription_i18n(taxonomyVocabulary.getDescription_i18n());
        }
        if (taxonomyVocabulary.getName() != null) {
            existingTaxonomyVocabulary.setName(taxonomyVocabulary.getName());
        }
        if (taxonomyVocabulary.getName_i18n() != null) {
            existingTaxonomyVocabulary.setName_i18n(taxonomyVocabulary.getName_i18n());
        }
        if (taxonomyVocabulary.getNumberOfTaxonomyCategories() != null) {
            existingTaxonomyVocabulary.setNumberOfTaxonomyCategories(taxonomyVocabulary.getNumberOfTaxonomyCategories());
        }
        if (taxonomyVocabulary.getSiteId() != null) {
            existingTaxonomyVocabulary.setSiteId(taxonomyVocabulary.getSiteId());
        }
        if (taxonomyVocabulary.getViewableBy() != null) {
            existingTaxonomyVocabulary.setViewableBy(taxonomyVocabulary.getViewableBy());
        }
        this.preparePatch(taxonomyVocabulary, existingTaxonomyVocabulary);
        return this.putTaxonomyVocabulary(taxonomyVocabularyId, existingTaxonomyVocabulary);
    }

    @Operation(description="Replaces the taxonomy vocabulary with the information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public TaxonomyVocabulary putTaxonomyVocabulary(@Parameter(hidden=true) @NotNull @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    @Consumes(value={"application/json"})
    @Path(value="/taxonomy-vocabularies/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putTaxonomyVocabularyBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(TaxonomyVocabulary.class.getName(), callbackURL, object)).build();
    }

    public void create(Collection<TaxonomyVocabulary> taxonomyVocabularies, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer taxonomyVocabularyUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("siteId")) {
                taxonomyVocabularyUnsafeConsumer = taxonomyVocabulary -> this.postSiteTaxonomyVocabulary((Long)parameters.get("siteId"), (TaxonomyVocabulary)taxonomyVocabulary);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [siteId]");
            }
        }
        if (taxonomyVocabularyUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for TaxonomyVocabulary");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(taxonomyVocabularies, (Object)taxonomyVocabularyUnsafeConsumer);
        } else {
            for (TaxonomyVocabulary taxonomyVocabulary2 : taxonomyVocabularies) {
                taxonomyVocabularyUnsafeConsumer.accept((Object)taxonomyVocabulary2);
            }
        }
    }

    public void delete(Collection<TaxonomyVocabulary> taxonomyVocabularies, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyVocabulary taxonomyVocabulary : taxonomyVocabularies) {
            this.deleteTaxonomyVocabulary(taxonomyVocabulary.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<TaxonomyVocabulary> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<TaxonomyVocabulary> taxonomyVocabularies, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer taxonomyVocabularyUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            taxonomyVocabularyUnsafeConsumer = taxonomyVocabulary -> this.patchTaxonomyVocabulary(taxonomyVocabulary.getId() != null ? taxonomyVocabulary.getId() : Long.parseLong((String)parameters.get("taxonomyVocabularyId")), (TaxonomyVocabulary)taxonomyVocabulary);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            taxonomyVocabularyUnsafeConsumer = taxonomyVocabulary -> this.putTaxonomyVocabulary(taxonomyVocabulary.getId() != null ? taxonomyVocabulary.getId() : Long.parseLong((String)parameters.get("taxonomyVocabularyId")), (TaxonomyVocabulary)taxonomyVocabulary);
        }
        if (taxonomyVocabularyUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for TaxonomyVocabulary");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(taxonomyVocabularies, (Object)taxonomyVocabularyUnsafeConsumer);
        } else {
            for (TaxonomyVocabulary taxonomyVocabulary2 : taxonomyVocabularies) {
                taxonomyVocabularyUnsafeConsumer.accept((Object)taxonomyVocabulary2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<TaxonomyVocabulary>, UnsafeConsumer<TaxonomyVocabulary, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(TaxonomyVocabulary taxonomyVocabulary, TaxonomyVocabulary existingTaxonomyVocabulary) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

