/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.graphql.mutation.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.KeywordResource;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Mutation {
    private static ComponentServiceObjects<KeywordResource> _keywordResourceComponentServiceObjects;
    private static ComponentServiceObjects<TaxonomyCategoryResource> _taxonomyCategoryResourceComponentServiceObjects;
    private static ComponentServiceObjects<TaxonomyVocabularyResource> _taxonomyVocabularyResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;
    private VulcanBatchEngineImportTaskResource _vulcanBatchEngineImportTaskResource;

    public static void setKeywordResourceComponentServiceObjects(ComponentServiceObjects<KeywordResource> keywordResourceComponentServiceObjects) {
        _keywordResourceComponentServiceObjects = keywordResourceComponentServiceObjects;
    }

    public static void setTaxonomyCategoryResourceComponentServiceObjects(ComponentServiceObjects<TaxonomyCategoryResource> taxonomyCategoryResourceComponentServiceObjects) {
        _taxonomyCategoryResourceComponentServiceObjects = taxonomyCategoryResourceComponentServiceObjects;
    }

    public static void setTaxonomyVocabularyResourceComponentServiceObjects(ComponentServiceObjects<TaxonomyVocabularyResource> taxonomyVocabularyResourceComponentServiceObjects) {
        _taxonomyVocabularyResourceComponentServiceObjects = taxonomyVocabularyResourceComponentServiceObjects;
    }

    @GraphQLField(description="Deletes the keyword and returns a 204 if the operation succeeds.")
    public @GraphQLField(description="Deletes the keyword and returns a 204 if the operation succeeds.") boolean deleteKeyword(@GraphQLName(value="keywordId") Long keywordId) throws Exception {
        this._applyVoidComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.deleteKeyword(keywordId));
        return true;
    }

    @GraphQLField
    public Response deleteKeywordBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.deleteKeywordBatch(callbackURL, object));
    }

    @GraphQLField(description="Replaces the keyword with the information sent in the request body. Any missing fields are deleted, unless required.")
    public @GraphQLField(description="Replaces the keyword with the information sent in the request body. Any missing fields are deleted, unless required.") Keyword updateKeyword(@GraphQLName(value="keywordId") Long keywordId, @GraphQLName(value="keyword") Keyword keyword) throws Exception {
        return (Keyword)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.putKeyword(keywordId, keyword));
    }

    @GraphQLField
    public Response updateKeywordBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.putKeywordBatch(callbackURL, object));
    }

    @GraphQLField(description="Inserts a new keyword in a Site.")
    public @GraphQLField(description="Inserts a new keyword in a Site.") Keyword createSiteKeyword(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="keyword") Keyword keyword) throws Exception {
        return (Keyword)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.postSiteKeyword(Long.valueOf(siteKey), keyword));
    }

    @GraphQLField
    public Response createSiteKeywordBatch(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_keywordResourceComponentServiceObjects, this::_populateResourceContext, keywordResource -> keywordResource.postSiteKeywordBatch(Long.valueOf(siteKey), callbackURL, object));
    }

    @GraphQLField(description="Inserts a new child taxonomy category.")
    public @GraphQLField(description="Inserts a new child taxonomy category.") TaxonomyCategory createTaxonomyCategoryTaxonomyCategory(@GraphQLName(value="parentTaxonomyCategoryId") Long parentTaxonomyCategoryId, @GraphQLName(value="taxonomyCategory") TaxonomyCategory taxonomyCategory) throws Exception {
        return (TaxonomyCategory)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.postTaxonomyCategoryTaxonomyCategory(parentTaxonomyCategoryId, taxonomyCategory));
    }

    @GraphQLField(description="Deletes the taxonomy category and returns a 204 if the operation succeeds.")
    public @GraphQLField(description="Deletes the taxonomy category and returns a 204 if the operation succeeds.") boolean deleteTaxonomyCategory(@GraphQLName(value="taxonomyCategoryId") Long taxonomyCategoryId) throws Exception {
        this._applyVoidComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.deleteTaxonomyCategory(taxonomyCategoryId));
        return true;
    }

    @GraphQLField
    public Response deleteTaxonomyCategoryBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.deleteTaxonomyCategoryBatch(callbackURL, object));
    }

    @GraphQLField(description="Updates only the fields received in the request body. Other fields are left untouched.")
    public @GraphQLField(description="Updates only the fields received in the request body. Other fields are left untouched.") TaxonomyCategory patchTaxonomyCategory(@GraphQLName(value="taxonomyCategoryId") Long taxonomyCategoryId, @GraphQLName(value="taxonomyCategory") TaxonomyCategory taxonomyCategory) throws Exception {
        return (TaxonomyCategory)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.patchTaxonomyCategory(taxonomyCategoryId, taxonomyCategory));
    }

    @GraphQLField(description="Replaces the taxonomy category with the information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the taxonomy category with the information sent in the request body. Any missing fields are deleted unless they are required.") TaxonomyCategory updateTaxonomyCategory(@GraphQLName(value="taxonomyCategoryId") Long taxonomyCategoryId, @GraphQLName(value="taxonomyCategory") TaxonomyCategory taxonomyCategory) throws Exception {
        return (TaxonomyCategory)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.putTaxonomyCategory(taxonomyCategoryId, taxonomyCategory));
    }

    @GraphQLField
    public Response updateTaxonomyCategoryBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.putTaxonomyCategoryBatch(callbackURL, object));
    }

    @GraphQLField(description="Inserts a new taxonomy category in a taxonomy vocabulary.")
    public @GraphQLField(description="Inserts a new taxonomy category in a taxonomy vocabulary.") TaxonomyCategory createTaxonomyVocabularyTaxonomyCategory(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="taxonomyCategory") TaxonomyCategory taxonomyCategory) throws Exception {
        return (TaxonomyCategory)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.postTaxonomyVocabularyTaxonomyCategory(taxonomyVocabularyId, taxonomyCategory));
    }

    @GraphQLField
    public Response createTaxonomyVocabularyTaxonomyCategoryBatch(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_taxonomyCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxonomyCategoryResource -> taxonomyCategoryResource.postTaxonomyVocabularyTaxonomyCategoryBatch(taxonomyVocabularyId, callbackURL, object));
    }

    @GraphQLField(description="Inserts a new taxonomy vocabulary in a Site.")
    public @GraphQLField(description="Inserts a new taxonomy vocabulary in a Site.") TaxonomyVocabulary createSiteTaxonomyVocabulary(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="taxonomyVocabulary") TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return (TaxonomyVocabulary)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.postSiteTaxonomyVocabulary(Long.valueOf(siteKey), taxonomyVocabulary));
    }

    @GraphQLField
    public Response createSiteTaxonomyVocabularyBatch(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.postSiteTaxonomyVocabularyBatch(Long.valueOf(siteKey), callbackURL, object));
    }

    @GraphQLField(description="Deletes the taxonomy vocabulary and returns a 204 if the operation succeeds.")
    public @GraphQLField(description="Deletes the taxonomy vocabulary and returns a 204 if the operation succeeds.") boolean deleteTaxonomyVocabulary(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
        this._applyVoidComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.deleteTaxonomyVocabulary(taxonomyVocabularyId));
        return true;
    }

    @GraphQLField
    public Response deleteTaxonomyVocabularyBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.deleteTaxonomyVocabularyBatch(callbackURL, object));
    }

    @GraphQLField(description="Updates only the fields received in the request body. Any other fields are left untouched.")
    public @GraphQLField(description="Updates only the fields received in the request body. Any other fields are left untouched.") TaxonomyVocabulary patchTaxonomyVocabulary(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="taxonomyVocabulary") TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return (TaxonomyVocabulary)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.patchTaxonomyVocabulary(taxonomyVocabularyId, taxonomyVocabulary));
    }

    @GraphQLField(description="Replaces the taxonomy vocabulary with the information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the taxonomy vocabulary with the information sent in the request body. Any missing fields are deleted unless they are required.") TaxonomyVocabulary updateTaxonomyVocabulary(@GraphQLName(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @GraphQLName(value="taxonomyVocabulary") TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return (TaxonomyVocabulary)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.putTaxonomyVocabulary(taxonomyVocabularyId, taxonomyVocabulary));
    }

    @GraphQLField
    public Response updateTaxonomyVocabularyBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_taxonomyVocabularyResourceComponentServiceObjects, this::_populateResourceContext, taxonomyVocabularyResource -> taxonomyVocabularyResource.putTaxonomyVocabularyBatch(callbackURL, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E1 extends Throwable, E2 extends Throwable> void _applyVoidComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeConsumer<T, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            unsafeFunction.accept(resource);
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(KeywordResource keywordResource) throws Exception {
        keywordResource.setContextAcceptLanguage(this._acceptLanguage);
        keywordResource.setContextCompany(this._company);
        keywordResource.setContextHttpServletRequest(this._httpServletRequest);
        keywordResource.setContextHttpServletResponse(this._httpServletResponse);
        keywordResource.setContextUriInfo(this._uriInfo);
        keywordResource.setContextUser(this._user);
        keywordResource.setGroupLocalService(this._groupLocalService);
        keywordResource.setRoleLocalService(this._roleLocalService);
        keywordResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(TaxonomyCategoryResource taxonomyCategoryResource) throws Exception {
        taxonomyCategoryResource.setContextAcceptLanguage(this._acceptLanguage);
        taxonomyCategoryResource.setContextCompany(this._company);
        taxonomyCategoryResource.setContextHttpServletRequest(this._httpServletRequest);
        taxonomyCategoryResource.setContextHttpServletResponse(this._httpServletResponse);
        taxonomyCategoryResource.setContextUriInfo(this._uriInfo);
        taxonomyCategoryResource.setContextUser(this._user);
        taxonomyCategoryResource.setGroupLocalService(this._groupLocalService);
        taxonomyCategoryResource.setRoleLocalService(this._roleLocalService);
        taxonomyCategoryResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(TaxonomyVocabularyResource taxonomyVocabularyResource) throws Exception {
        taxonomyVocabularyResource.setContextAcceptLanguage(this._acceptLanguage);
        taxonomyVocabularyResource.setContextCompany(this._company);
        taxonomyVocabularyResource.setContextHttpServletRequest(this._httpServletRequest);
        taxonomyVocabularyResource.setContextHttpServletResponse(this._httpServletResponse);
        taxonomyVocabularyResource.setContextUriInfo(this._uriInfo);
        taxonomyVocabularyResource.setContextUser(this._user);
        taxonomyVocabularyResource.setGroupLocalService(this._groupLocalService);
        taxonomyVocabularyResource.setRoleLocalService(this._roleLocalService);
        taxonomyVocabularyResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }
}

