/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.AssetType;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.taxonomy.internal.odata.entity.v1_0.VocabularyEntityModel;
import com.liferay.headless.admin.taxonomy.internal.resource.v1_0.BaseTaxonomyVocabularyResourceImpl;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ContentLanguageUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/taxonomy-vocabulary.properties"}, scope=ServiceScope.PROTOTYPE, service={TaxonomyVocabularyResource.class})
public class TaxonomyVocabularyResourceImpl
extends BaseTaxonomyVocabularyResourceImpl
implements EntityModelResource {
    private static final Map<String, String> _assetTypeTypeToClassNames = new HashMap<String, String>(){
        {
            this.put("BlogPosting", "com.liferay.blogs.model.BlogsEntry");
            this.put("Document", "com.liferay.document.library.kernel.model.DLFileEntry");
            this.put("KnowledgeBaseArticle", "com.liferay.knowledge.base.model.KBArticle");
            this.put("Organization", Organization.class.getName());
            this.put("StructuredContent", "com.liferay.journal.model.JournalArticle");
            this.put("UserAccount", User.class.getName());
            this.put("WebPage", Layout.class.getName());
            this.put("WebSite", Group.class.getName());
            this.put("WikiPage", "com.liferay.wiki.model.WikiPage");
        }
    };
    private static final Map<String, String> _classNameToAssetTypeTypes = MapUtils.invertMap(_assetTypeTypeToClassNames);
    private static final EntityModel _entityModel = new VocabularyEntityModel();
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Context
    private HttpServletResponse _httpServletResponse;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteTaxonomyVocabulary(Long taxonomyVocabularyId) throws Exception {
        this._assetVocabularyService.deleteVocabulary(taxonomyVocabularyId.longValue());
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Page<TaxonomyVocabulary> getSiteTaxonomyVocabulariesPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {}, (Filter)filter, AssetVocabulary.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"assetVocabularyId"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toTaxonomyVocabulary(this._assetVocabularyService.getVocabulary(GetterUtil.getLong((String)document.get("assetVocabularyId")))), (Sort[])sorts);
    }

    @Override
    public TaxonomyVocabulary getTaxonomyVocabulary(Long taxonomyVocabularyId) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        ContentLanguageUtil.addContentLanguageHeader((String[])assetVocabulary.getAvailableLanguageIds(), (String)assetVocabulary.getDefaultLanguageId(), (HttpServletResponse)this._httpServletResponse, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        return this._toTaxonomyVocabulary(assetVocabulary);
    }

    @Override
    public TaxonomyVocabulary patchTaxonomyVocabulary(Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        if (!ArrayUtil.contains((Object[])assetVocabulary.getAvailableLanguageIds(), (Object)this.contextAcceptLanguage.getPreferredLanguageId())) {
            throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to patch taxonomy vocabulary with language ", LocaleUtil.toW3cLanguageId((String)this.contextAcceptLanguage.getPreferredLanguageId()), " because it is only available in the following languages ", LocaleUtil.toW3cLanguageIds((String[])assetVocabulary.getAvailableLanguageIds())}));
        }
        AssetType[] assetTypes = taxonomyVocabulary.getAssetTypes();
        if (assetTypes == null) {
            assetTypes = this._getAssetTypes(new AssetVocabularySettingsHelper(assetVocabulary.getSettings()), assetVocabulary.getGroupId());
        }
        return this._toTaxonomyVocabulary(this._assetVocabularyService.updateVocabulary(assetVocabulary.getVocabularyId(), null, LocalizedMapUtil.patch((Map)assetVocabulary.getTitleMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyVocabulary.getName()), LocalizedMapUtil.patch((Map)assetVocabulary.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyVocabulary.getDescription()), this._getSettings(assetTypes, assetVocabulary.getGroupId()), new ServiceContext()));
    }

    @Override
    public TaxonomyVocabulary postSiteTaxonomyVocabulary(Long siteId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        if (!LocaleUtil.equals((Locale)siteDefaultLocale, (Locale)this.contextAcceptLanguage.getPreferredLocale())) {
            String w3cLanguageId = LocaleUtil.toW3cLanguageId((Locale)siteDefaultLocale);
            throw new BadRequestException("Taxonomy vocabularies can only be created with the default language " + w3cLanguageId);
        }
        return this._toTaxonomyVocabulary(this._assetVocabularyService.addVocabulary(siteId.longValue(), null, Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), taxonomyVocabulary.getName()), Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), taxonomyVocabulary.getDescription()), this._getSettings(taxonomyVocabulary.getAssetTypes(), siteId), ServiceContextUtil.createServiceContext((long)siteId, (String)taxonomyVocabulary.getViewableByAsString())));
    }

    @Override
    public TaxonomyVocabulary putTaxonomyVocabulary(Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        return this._toTaxonomyVocabulary(this._assetVocabularyService.updateVocabulary(assetVocabulary.getVocabularyId(), null, LocalizedMapUtil.merge((Map)assetVocabulary.getTitleMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), taxonomyVocabulary.getName())), LocalizedMapUtil.merge((Map)assetVocabulary.getDescriptionMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), taxonomyVocabulary.getDescription())), this._getSettings(taxonomyVocabulary.getAssetTypes(), assetVocabulary.getGroupId()), new ServiceContext()));
    }

    private AssetType _getAssetType(final long groupId, final long classNameId, final long classTypePK, final long[] requiredClassNameIds) {
        return new AssetType(){
            {
                this.required = ArrayUtil.contains((long[])requiredClassNameIds, (long)classNameId);
                this.setSubtype(() -> {
                    if (classTypePK == -1L) {
                        return "AllAssetSubtypes";
                    }
                    AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)TaxonomyVocabularyResourceImpl.this._portal.getClassName(classNameId));
                    ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
                    List classTypes = classTypeReader.getAvailableClassTypes(new long[]{groupId, TaxonomyVocabularyResourceImpl.this.contextCompany.getGroupId()}, TaxonomyVocabularyResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                    if (ListUtil.isEmpty((List)classTypes)) {
                        return "AllAssetSubtypes";
                    }
                    for (ClassType classType : classTypes) {
                        if (classType.getClassTypeId() != classTypePK) continue;
                        return classType.getName();
                    }
                    throw new InternalServerErrorException();
                });
                this.setType(() -> {
                    if (classNameId == 0L) {
                        return "AllAssetTypes";
                    }
                    String assetTypeType = (String)_classNameToAssetTypeTypes.get(TaxonomyVocabularyResourceImpl.this._portal.getClassName(classNameId));
                    if (assetTypeType != null) {
                        return assetTypeType;
                    }
                    return TaxonomyVocabularyResourceImpl.this._getModelResource(AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)TaxonomyVocabularyResourceImpl.this._portal.getClassName(classNameId)));
                });
            }
        };
    }

    private AssetType[] _getAssetTypes(AssetVocabularySettingsHelper assetVocabularySettingsHelper, long groupId) {
        long[] classNameIds = assetVocabularySettingsHelper.getClassNameIds();
        if (ArrayUtil.isEmpty((long[])classNameIds)) {
            return new AssetType[0];
        }
        AssetType[] assetTypes = new AssetType[classNameIds.length];
        long[] classTypePKs = assetVocabularySettingsHelper.getClassTypePKs();
        long[] requiredClassNameIds = assetVocabularySettingsHelper.getRequiredClassNameIds();
        for (int i = 0; i < classNameIds.length; ++i) {
            long classNameId = classNameIds[i];
            long classTypePK = classTypePKs[i];
            assetTypes[i] = this._getAssetType(groupId, classNameId, classTypePK, requiredClassNameIds);
        }
        return assetTypes;
    }

    private String _getAvailableAssetTypes(List<AssetRendererFactory<?>> categorizableAssetRenderFactories) {
        List assetTypes = ListUtils.union(this.transform(categorizableAssetRenderFactories, assetRenderedFactory -> {
            String className = assetRenderedFactory.getClassName();
            String assetTypeType = _classNameToAssetTypeTypes.get(className);
            if (assetTypeType != null) {
                return assetTypeType;
            }
            return this._getModelResource((AssetRendererFactory<?>)assetRenderedFactory);
        }), Collections.singletonList("AllAssetTypes"));
        return Arrays.toString(assetTypes.toArray());
    }

    private long _getClassNameId(String assetTypeType) {
        if (Objects.equals(assetTypeType, "AllAssetTypes")) {
            return 0L;
        }
        List categorizableAssetRenderFactories = ListUtil.filter((List)AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)this.contextCompany.getCompanyId()), AssetRendererFactory::isCategorizable);
        Stream stream = categorizableAssetRenderFactories.stream();
        Optional<AssetRendererFactory> assetRendererFactoryOptional = stream.filter(assetRendererFactory -> assetTypeType.equals(this._getModelResource((AssetRendererFactory<?>)assetRendererFactory))).findFirst();
        String className = assetRendererFactoryOptional.map(AssetRendererFactory::getClassName).orElse(_assetTypeTypeToClassNames.get(assetTypeType));
        if (className == null) {
            throw new BadRequestException(StringBundler.concat((String[])new String[]{"Asset type ", assetTypeType, " not available, the supported asset types are: ", this._getAvailableAssetTypes(categorizableAssetRenderFactories)}));
        }
        return this._portal.getClassNameId(className);
    }

    private long _getClassTypePK(long classNameId, String subtype, long groupId) throws Exception {
        if (Objects.equals("AllAssetSubtypes", subtype) || classNameId == 0L || subtype == null) {
            return -1L;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this._portal.getClassName(classNameId));
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        List classTypes = classTypeReader.getAvailableClassTypes(new long[]{groupId, this.contextCompany.getGroupId()}, this.contextAcceptLanguage.getPreferredLocale());
        if (ListUtil.isEmpty((List)classTypes)) {
            return -1L;
        }
        for (ClassType classType : classTypes) {
            if (!Objects.equals(classType.getName(), subtype)) continue;
            return classType.getClassTypeId();
        }
        throw new BadRequestException("Invalid subtype " + subtype);
    }

    private String _getModelResource(AssetRendererFactory<?> assetRendererFactory) {
        return ResourceActionsUtil.getModelResource((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetRendererFactory.getClassName());
    }

    private String _getSettings(AssetType[] assetTypes, long groupId) throws Exception {
        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper();
        if (ArrayUtil.isEmpty((Object[])assetTypes)) {
            return assetVocabularySettingsHelper.toString();
        }
        long[] classNameIds = new long[assetTypes.length];
        long[] classTypePKs = new long[assetTypes.length];
        boolean[] requiredClassNameIds = new boolean[assetTypes.length];
        for (int i = 0; i < assetTypes.length; ++i) {
            long classNameId;
            AssetType assetType = assetTypes[i];
            classNameIds[i] = classNameId = this._getClassNameId(assetType.getType());
            classTypePKs[i] = this._getClassTypePK(classNameId, assetType.getSubtype(), groupId);
            requiredClassNameIds[i] = assetType.getRequired();
        }
        assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requiredClassNameIds);
        assetVocabularySettingsHelper.setMultiValued(true);
        return assetVocabularySettingsHelper.toString();
    }

    private TaxonomyVocabulary _toTaxonomyVocabulary(final AssetVocabulary assetVocabulary) throws Exception {
        return new TaxonomyVocabulary(){
            {
                this.assetTypes = TaxonomyVocabularyResourceImpl.this._getAssetTypes(new AssetVocabularySettingsHelper(assetVocabulary.getSettings()), assetVocabulary.getGroupId());
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])assetVocabulary.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(TaxonomyVocabularyResourceImpl.this._portal, TaxonomyVocabularyResourceImpl.this._userLocalService.getUser(assetVocabulary.getUserId()));
                this.dateCreated = assetVocabulary.getCreateDate();
                this.dateModified = assetVocabulary.getModifiedDate();
                this.description = assetVocabulary.getDescription(TaxonomyVocabularyResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = assetVocabulary.getVocabularyId();
                this.name = assetVocabulary.getTitle(TaxonomyVocabularyResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.numberOfTaxonomyCategories = Optional.ofNullable(assetVocabulary.getCategories()).map(List::size).orElse(0);
                this.siteId = assetVocabulary.getGroupId();
            }
        };
    }
}

