/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.ParentTaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.ParentTaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.taxonomy.internal.odata.entity.v1_0.CategoryEntityModel;
import com.liferay.headless.admin.taxonomy.internal.resource.v1_0.BaseTaxonomyCategoryResourceImpl;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ContentLanguageUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/taxonomy-category.properties"}, scope=ServiceScope.PROTOTYPE, service={TaxonomyCategoryResource.class})
public class TaxonomyCategoryResourceImpl
extends BaseTaxonomyCategoryResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new CategoryEntityModel();
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Context
    private HttpServletResponse _httpServletResponse;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteTaxonomyCategory(Long taxonomyCategoryId) throws Exception {
        this._assetCategoryService.deleteCategory(taxonomyCategoryId.longValue());
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public TaxonomyCategory getTaxonomyCategory(Long taxonomyCategoryId) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(taxonomyCategoryId.longValue());
        ContentLanguageUtil.addContentLanguageHeader((String[])assetCategory.getAvailableLanguageIds(), (String)assetCategory.getDefaultLanguageId(), (HttpServletResponse)this._httpServletResponse, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        return this._toTaxonomyCategory(assetCategory);
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyCategoryTaxonomyCategoriesPage(Long parentTaxonomyCategoryId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getCategoriesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (parentTaxonomyCategoryId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(parentTaxonomyCategoryId)), BooleanClauseOccur.MUST);
            }
        }), search, filter, pagination, sorts);
    }

    @Override
    public Page<TaxonomyCategory> getTaxonomyVocabularyTaxonomyCategoriesPage(Long taxonomyVocabularyId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getCategoriesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (taxonomyVocabularyId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(0L)), BooleanClauseOccur.MUST);
                booleanFilter.add((Filter)new TermFilter("assetVocabularyId", String.valueOf(taxonomyVocabularyId)), BooleanClauseOccur.MUST);
            }
        }), search, filter, pagination, sorts);
    }

    @Override
    public TaxonomyCategory patchTaxonomyCategory(Long taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(taxonomyCategoryId.longValue());
        if (!ArrayUtil.contains((Object[])assetCategory.getAvailableLanguageIds(), (Object)this.contextAcceptLanguage.getPreferredLanguageId())) {
            throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to patch taxonomy category with language ", LocaleUtil.toW3cLanguageId((String)this.contextAcceptLanguage.getPreferredLanguageId()), " because it is only available in the following languages ", LocaleUtil.toW3cLanguageIds((String[])assetCategory.getAvailableLanguageIds())}));
        }
        return this._toTaxonomyCategory(this._assetCategoryService.updateCategory(taxonomyCategoryId.longValue(), assetCategory.getParentCategoryId(), LocalizedMapUtil.patch((Map)assetCategory.getTitleMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getName()), LocalizedMapUtil.patch((Map)assetCategory.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)taxonomyCategory.getDescription()), assetCategory.getVocabularyId(), null, new ServiceContext()));
    }

    @Override
    public TaxonomyCategory postTaxonomyCategoryTaxonomyCategory(Long parentTaxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(parentTaxonomyCategoryId.longValue());
        return this._addTaxonomyCategory(assetCategory.getGroupId(), assetCategory.getDefaultLanguageId(), taxonomyCategory, assetCategory.getCategoryId(), assetCategory.getVocabularyId());
    }

    @Override
    public TaxonomyCategory postTaxonomyVocabularyTaxonomyCategory(Long taxonomyVocabularyId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(taxonomyVocabularyId.longValue());
        return this._addTaxonomyCategory(assetVocabulary.getGroupId(), assetVocabulary.getDefaultLanguageId(), taxonomyCategory, 0L, assetVocabulary.getVocabularyId());
    }

    @Override
    public TaxonomyCategory putTaxonomyCategory(Long taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(taxonomyCategoryId.longValue());
        return this._toTaxonomyCategory(this._assetCategoryService.updateCategory(taxonomyCategoryId.longValue(), assetCategory.getParentCategoryId(), LocalizedMapUtil.merge((Map)assetCategory.getTitleMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), taxonomyCategory.getName())), LocalizedMapUtil.merge((Map)assetCategory.getDescriptionMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), taxonomyCategory.getDescription())), assetCategory.getVocabularyId(), null, new ServiceContext()));
    }

    private TaxonomyCategory _addTaxonomyCategory(long groupId, String languageId, TaxonomyCategory taxonomyCategory, long taxonomyCategoryId, long taxonomyVocabularyId) throws Exception {
        if (!LocaleUtil.equals((Locale)LocaleUtil.fromLanguageId((String)languageId), (Locale)this.contextAcceptLanguage.getPreferredLocale())) {
            String w3cLanguageId = LocaleUtil.toW3cLanguageId((String)languageId);
            throw new BadRequestException("Taxonomy categories can only be created with the default language " + w3cLanguageId);
        }
        return this._toTaxonomyCategory(this._assetCategoryService.addCategory(groupId, taxonomyCategoryId, Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), taxonomyCategory.getName()), Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), taxonomyCategory.getDescription()), taxonomyVocabularyId, null, ServiceContextUtil.createServiceContext((long)groupId, (String)taxonomyCategory.getViewableByAsString())));
    }

    private Page<TaxonomyCategory> _getCategoriesPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, AssetCategory.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"assetCategoryId"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toTaxonomyCategory(this._assetCategoryService.getCategory(GetterUtil.getLong((String)document.get("assetCategoryId")))), (Sort[])sorts);
    }

    private ParentTaxonomyCategory _toParentCategory(final AssetCategory parentCategory) {
        return new ParentTaxonomyCategory(){
            {
                this.id = parentCategory.getCategoryId();
                this.name = parentCategory.getTitle(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
            }
        };
    }

    private TaxonomyCategory _toTaxonomyCategory(final AssetCategory assetCategory) throws Exception {
        return new TaxonomyCategory(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])assetCategory.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(TaxonomyCategoryResourceImpl.this._portal, TaxonomyCategoryResourceImpl.this._userLocalService.getUserById(assetCategory.getUserId()));
                this.dateCreated = assetCategory.getCreateDate();
                this.dateModified = assetCategory.getModifiedDate();
                this.description = assetCategory.getDescription(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = assetCategory.getCategoryId();
                this.name = assetCategory.getTitle(TaxonomyCategoryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.numberOfTaxonomyCategories = TaxonomyCategoryResourceImpl.this._assetCategoryService.getChildCategoriesCount(assetCategory.getCategoryId());
                this.parentTaxonomyVocabulary = new ParentTaxonomyVocabulary(){
                    {
                        this.id = assetCategory.getVocabularyId();
                        this.setName(() -> {
                            AssetVocabulary assetVocabulary = TaxonomyCategoryResourceImpl.this._assetVocabularyService.getVocabulary(assetCategory.getVocabularyId());
                            return assetVocabulary.getName();
                        });
                    }
                };
                this.setParentTaxonomyCategory(() -> {
                    if (assetCategory.getParentCategory() == null) {
                        return null;
                    }
                    return TaxonomyCategoryResourceImpl.this._toParentCategory(assetCategory.getParentCategory());
                });
            }
        };
    }
}

