/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseTaxonomyVocabularyResourceImpl
implements TaxonomyVocabularyResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @GET
    @Operation(description="Retrieves a Site's taxonomy vocabularies. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<TaxonomyVocabulary> getSiteTaxonomyVocabulariesPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Inserts a new taxonomy vocabulary in a Site.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary postSiteTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    @DELETE
    @Operation(description="Deletes the taxonomy vocabulary and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public void deleteTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves a taxonomy vocabulary.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary getTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body. Any other fields are left untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary patchTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        TaxonomyVocabulary existingTaxonomyVocabulary = this.getTaxonomyVocabulary(taxonomyVocabularyId);
        if (taxonomyVocabulary.getAvailableLanguages() != null) {
            existingTaxonomyVocabulary.setAvailableLanguages(taxonomyVocabulary.getAvailableLanguages());
        }
        if (taxonomyVocabulary.getDateCreated() != null) {
            existingTaxonomyVocabulary.setDateCreated(taxonomyVocabulary.getDateCreated());
        }
        if (taxonomyVocabulary.getDateModified() != null) {
            existingTaxonomyVocabulary.setDateModified(taxonomyVocabulary.getDateModified());
        }
        if (taxonomyVocabulary.getDescription() != null) {
            existingTaxonomyVocabulary.setDescription(taxonomyVocabulary.getDescription());
        }
        if (taxonomyVocabulary.getName() != null) {
            existingTaxonomyVocabulary.setName(taxonomyVocabulary.getName());
        }
        if (taxonomyVocabulary.getNumberOfTaxonomyCategories() != null) {
            existingTaxonomyVocabulary.setNumberOfTaxonomyCategories(taxonomyVocabulary.getNumberOfTaxonomyCategories());
        }
        if (taxonomyVocabulary.getSiteId() != null) {
            existingTaxonomyVocabulary.setSiteId(taxonomyVocabulary.getSiteId());
        }
        if (taxonomyVocabulary.getViewableBy() != null) {
            existingTaxonomyVocabulary.setViewableBy(taxonomyVocabulary.getViewableBy());
        }
        this.preparePatch(taxonomyVocabulary, existingTaxonomyVocabulary);
        return this.putTaxonomyVocabulary(taxonomyVocabularyId, existingTaxonomyVocabulary);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the taxonomy vocabulary with the information sent in the request body. Any missing fields are deleted unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary putTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(TaxonomyVocabulary taxonomyVocabulary, TaxonomyVocabulary existingTaxonomyVocabulary) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

