/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.resource.v1_0.KeywordResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseKeywordResourceImpl
implements KeywordResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @DELETE
    @Operation(description="Deletes the keyword and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="keywordId")})
    @Path(value="/keywords/{keywordId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Keyword")})
    public void deleteKeyword(@NotNull @Parameter(hidden=true) @PathParam(value="keywordId") Long keywordId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves a keyword.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="keywordId")})
    @Path(value="/keywords/{keywordId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Keyword")})
    public Keyword getKeyword(@NotNull @Parameter(hidden=true) @PathParam(value="keywordId") Long keywordId) throws Exception {
        return new Keyword();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the keyword with the information sent in the request body. Any missing fields are deleted, unless required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="keywordId")})
    @Path(value="/keywords/{keywordId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Keyword")})
    public Keyword putKeyword(@NotNull @Parameter(hidden=true) @PathParam(value="keywordId") Long keywordId, Keyword keyword) throws Exception {
        return new Keyword();
    }

    @GET
    @Operation(description="Retrieves a Site's keywords. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/keywords")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Keyword")})
    public Page<Keyword> getSiteKeywordsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Inserts a new keyword in a Site.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/keywords")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Keyword")})
    public Keyword postSiteKeyword(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Keyword keyword) throws Exception {
        return new Keyword();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(Keyword keyword, Keyword existingKeyword) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

