/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.client.serdes.v1_0;

import com.liferay.headless.admin.taxonomy.client.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.client.json.BaseJSONParser;
import com.liferay.headless.admin.taxonomy.client.serdes.v1_0.CreatorSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class KeywordSerDes {
    public static Keyword toDTO(String json) {
        KeywordJSONParser keywordJSONParser = new KeywordJSONParser();
        return (Keyword)keywordJSONParser.parseToDTO(json);
    }

    public static Keyword[] toDTOs(String json) {
        KeywordJSONParser keywordJSONParser = new KeywordJSONParser();
        return (Keyword[])keywordJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Keyword keyword) {
        if (keyword == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (keyword.getActions() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(KeywordSerDes._toJSON(keyword.getActions()));
        }
        if (keyword.getAssetLibraryKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assetLibraryKey\": ");
            sb.append("\"");
            sb.append(KeywordSerDes._escape(keyword.getAssetLibraryKey()));
            sb.append("\"");
        }
        if (keyword.getCreator() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(keyword.getCreator()));
        }
        if (keyword.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(keyword.getDateCreated()));
            sb.append("\"");
        }
        if (keyword.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(keyword.getDateModified()));
            sb.append("\"");
        }
        if (keyword.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(keyword.getId());
        }
        if (keyword.getKeywordUsageCount() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywordUsageCount\": ");
            sb.append(keyword.getKeywordUsageCount());
        }
        if (keyword.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(KeywordSerDes._escape(keyword.getName()));
            sb.append("\"");
        }
        if (keyword.getSiteId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append(keyword.getSiteId());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        KeywordJSONParser keywordJSONParser = new KeywordJSONParser();
        return keywordJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Keyword keyword) {
        if (keyword == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (keyword.getActions() == null) {
            map.put("actions", null);
        } else {
            map.put("actions", String.valueOf(keyword.getActions()));
        }
        if (keyword.getAssetLibraryKey() == null) {
            map.put("assetLibraryKey", null);
        } else {
            map.put("assetLibraryKey", String.valueOf(keyword.getAssetLibraryKey()));
        }
        if (keyword.getCreator() == null) {
            map.put("creator", null);
        } else {
            map.put("creator", String.valueOf(keyword.getCreator()));
        }
        if (keyword.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(keyword.getDateCreated()));
        }
        if (keyword.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(keyword.getDateModified()));
        }
        if (keyword.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(keyword.getId()));
        }
        if (keyword.getKeywordUsageCount() == null) {
            map.put("keywordUsageCount", null);
        } else {
            map.put("keywordUsageCount", String.valueOf(keyword.getKeywordUsageCount()));
        }
        if (keyword.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(keyword.getName()));
        }
        if (keyword.getSiteId() == null) {
            map.put("siteId", null);
        } else {
            map.put("siteId", String.valueOf(keyword.getSiteId()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(KeywordSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(KeywordSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(KeywordSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class KeywordJSONParser
    extends BaseJSONParser<Keyword> {
        @Override
        protected Keyword createDTO() {
            return new Keyword();
        }

        protected Keyword[] createDTOArray(int size) {
            return new Keyword[size];
        }

        @Override
        protected void setField(Keyword keyword, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "actions")) {
                if (jsonParserFieldValue != null) {
                    keyword.setActions(KeywordSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "assetLibraryKey")) {
                if (jsonParserFieldValue != null) {
                    keyword.setAssetLibraryKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "creator")) {
                if (jsonParserFieldValue != null) {
                    keyword.setCreator(CreatorSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    keyword.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    keyword.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    keyword.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "keywordUsageCount")) {
                if (jsonParserFieldValue != null) {
                    keyword.setKeywordUsageCount(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    keyword.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "siteId")) {
                if (jsonParserFieldValue != null) {
                    keyword.setSiteId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (jsonParserFieldName.equals("status")) {
                throw new IllegalArgumentException();
            }
        }
    }
}

