/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.client.serdes.v1_0;

import com.liferay.headless.admin.taxonomy.client.dto.v1_0.AssetType;
import com.liferay.headless.admin.taxonomy.client.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.client.json.BaseJSONParser;
import com.liferay.headless.admin.taxonomy.client.serdes.v1_0.AssetTypeSerDes;
import com.liferay.headless.admin.taxonomy.client.serdes.v1_0.CreatorSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;

public class TaxonomyVocabularySerDes {
    public static TaxonomyVocabulary toDTO(String json) {
        TaxonomyVocabularyJSONParser taxonomyVocabularyJSONParser = new TaxonomyVocabularyJSONParser();
        return (TaxonomyVocabulary)taxonomyVocabularyJSONParser.parseToDTO(json);
    }

    public static TaxonomyVocabulary[] toDTOs(String json) {
        TaxonomyVocabularyJSONParser taxonomyVocabularyJSONParser = new TaxonomyVocabularyJSONParser();
        return (TaxonomyVocabulary[])taxonomyVocabularyJSONParser.parseToDTOs(json);
    }

    public static String toJSON(TaxonomyVocabulary taxonomyVocabulary) {
        int i;
        if (taxonomyVocabulary == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (taxonomyVocabulary.getAssetTypes() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assetTypes\": ");
            sb.append("[");
            for (i = 0; i < taxonomyVocabulary.getAssetTypes().length; ++i) {
                sb.append(String.valueOf(taxonomyVocabulary.getAssetTypes()[i]));
                if (i + 1 >= taxonomyVocabulary.getAssetTypes().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (taxonomyVocabulary.getAvailableLanguages() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (i = 0; i < taxonomyVocabulary.getAvailableLanguages().length; ++i) {
                sb.append("\"");
                sb.append(TaxonomyVocabularySerDes._escape(taxonomyVocabulary.getAvailableLanguages()[i]));
                sb.append("\"");
                if (i + 1 >= taxonomyVocabulary.getAvailableLanguages().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (taxonomyVocabulary.getCreator() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(taxonomyVocabulary.getCreator()));
        }
        if (taxonomyVocabulary.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(taxonomyVocabulary.getDateCreated()));
            sb.append("\"");
        }
        if (taxonomyVocabulary.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(taxonomyVocabulary.getDateModified()));
            sb.append("\"");
        }
        if (taxonomyVocabulary.getDescription() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(TaxonomyVocabularySerDes._escape(taxonomyVocabulary.getDescription()));
            sb.append("\"");
        }
        if (taxonomyVocabulary.getDescription_i18n() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(TaxonomyVocabularySerDes._toJSON(taxonomyVocabulary.getDescription_i18n()));
        }
        if (taxonomyVocabulary.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(taxonomyVocabulary.getId());
        }
        if (taxonomyVocabulary.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(TaxonomyVocabularySerDes._escape(taxonomyVocabulary.getName()));
            sb.append("\"");
        }
        if (taxonomyVocabulary.getName_i18n() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(TaxonomyVocabularySerDes._toJSON(taxonomyVocabulary.getName_i18n()));
        }
        if (taxonomyVocabulary.getNumberOfTaxonomyCategories() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfTaxonomyCategories\": ");
            sb.append(taxonomyVocabulary.getNumberOfTaxonomyCategories());
        }
        if (taxonomyVocabulary.getSiteId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append(taxonomyVocabulary.getSiteId());
        }
        if (taxonomyVocabulary.getViewableBy() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)taxonomyVocabulary.getViewableBy());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        TaxonomyVocabularyJSONParser taxonomyVocabularyJSONParser = new TaxonomyVocabularyJSONParser();
        return taxonomyVocabularyJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(TaxonomyVocabulary taxonomyVocabulary) {
        if (taxonomyVocabulary == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (taxonomyVocabulary.getAssetTypes() == null) {
            map.put("assetTypes", null);
        } else {
            map.put("assetTypes", String.valueOf(taxonomyVocabulary.getAssetTypes()));
        }
        if (taxonomyVocabulary.getAvailableLanguages() == null) {
            map.put("availableLanguages", null);
        } else {
            map.put("availableLanguages", String.valueOf(taxonomyVocabulary.getAvailableLanguages()));
        }
        if (taxonomyVocabulary.getCreator() == null) {
            map.put("creator", null);
        } else {
            map.put("creator", String.valueOf(taxonomyVocabulary.getCreator()));
        }
        if (taxonomyVocabulary.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(taxonomyVocabulary.getDateCreated()));
        }
        if (taxonomyVocabulary.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(taxonomyVocabulary.getDateModified()));
        }
        if (taxonomyVocabulary.getDescription() == null) {
            map.put("description", null);
        } else {
            map.put("description", String.valueOf(taxonomyVocabulary.getDescription()));
        }
        if (taxonomyVocabulary.getDescription_i18n() == null) {
            map.put("description_i18n", null);
        } else {
            map.put("description_i18n", String.valueOf(taxonomyVocabulary.getDescription_i18n()));
        }
        if (taxonomyVocabulary.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(taxonomyVocabulary.getId()));
        }
        if (taxonomyVocabulary.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(taxonomyVocabulary.getName()));
        }
        if (taxonomyVocabulary.getName_i18n() == null) {
            map.put("name_i18n", null);
        } else {
            map.put("name_i18n", String.valueOf(taxonomyVocabulary.getName_i18n()));
        }
        if (taxonomyVocabulary.getNumberOfTaxonomyCategories() == null) {
            map.put("numberOfTaxonomyCategories", null);
        } else {
            map.put("numberOfTaxonomyCategories", String.valueOf(taxonomyVocabulary.getNumberOfTaxonomyCategories()));
        }
        if (taxonomyVocabulary.getSiteId() == null) {
            map.put("siteId", null);
        } else {
            map.put("siteId", String.valueOf(taxonomyVocabulary.getSiteId()));
        }
        if (taxonomyVocabulary.getViewableBy() == null) {
            map.put("viewableBy", null);
        } else {
            map.put("viewableBy", String.valueOf((Object)taxonomyVocabulary.getViewableBy()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(TaxonomyVocabularySerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(TaxonomyVocabularySerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(TaxonomyVocabularySerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class TaxonomyVocabularyJSONParser
    extends BaseJSONParser<TaxonomyVocabulary> {
        @Override
        protected TaxonomyVocabulary createDTO() {
            return new TaxonomyVocabulary();
        }

        protected TaxonomyVocabulary[] createDTOArray(int size) {
            return new TaxonomyVocabulary[size];
        }

        @Override
        protected void setField(TaxonomyVocabulary taxonomyVocabulary, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "assetTypes")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setAssetTypes((AssetType[])Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(object -> AssetTypeSerDes.toDTO(object)).toArray(AssetType[]::new));
                }
            } else if (Objects.equals(jsonParserFieldName, "availableLanguages")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setAvailableLanguages(this.toStrings((Object[])jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "creator")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setCreator(CreatorSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "description")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setDescription((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "description_i18n")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setDescription_i18n(TaxonomyVocabularySerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "name_i18n")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setName_i18n(TaxonomyVocabularySerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "numberOfTaxonomyCategories")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setNumberOfTaxonomyCategories(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "siteId")) {
                if (jsonParserFieldValue != null) {
                    taxonomyVocabulary.setSiteId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "viewableBy") && jsonParserFieldValue != null) {
                taxonomyVocabulary.setViewableBy(TaxonomyVocabulary.ViewableBy.create((String)jsonParserFieldValue));
            }
        }
    }
}

