/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.taxonomy.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a keyword that describes content. Properties follow the [keywords](https://schema.org/keywords) specification.", value="Keyword")
@JsonFilter(value="Liferay.Vulcan")
@Schema(description="Represents a keyword that describes content. Properties follow the [keywords](https://schema.org/keywords) specification.", requiredProperties={"name"})
@XmlRootElement(name="Keyword")
public class Keyword
implements Serializable {
    @GraphQLField(description="The keyword's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The keyword's creator.") Creator creator;
    @GraphQLField(description="The keyword's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The keyword's creation date.") Date dateCreated;
    @GraphQLField(description="The keyword's most recent modification date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The keyword's most recent modification date.") Date dateModified;
    @GraphQLField(description="The keyword's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The keyword's ID.") Long id;
    @GraphQLField(description="The number of times this keyword has been used with other assets.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of times this keyword has been used with other assets.") Integer keywordUsageCount;
    @GraphQLField(description="The keyword's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The keyword's name.") @NotEmpty String name;
    @GraphQLField(description="The ID of the site to which this keyword is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this keyword is scoped.") Long siteId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword", name="x-class-name")
    public String xClassName;

    public static Keyword toDTO(String json) {
        return (Keyword)ObjectMapperUtil.readValue(Keyword.class, (String)json);
    }

    public static Keyword unsafeToDTO(String json) {
        return (Keyword)ObjectMapperUtil.unsafeReadValue(Keyword.class, (String)json);
    }

    @Schema(description="The keyword's creator.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The keyword's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The keyword's most recent modification date.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The keyword's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of times this keyword has been used with other assets.")
    public Integer getKeywordUsageCount() {
        return this.keywordUsageCount;
    }

    public void setKeywordUsageCount(Integer keywordUsageCount) {
        this.keywordUsageCount = keywordUsageCount;
    }

    @JsonIgnore
    public void setKeywordUsageCount(UnsafeSupplier<Integer, Exception> keywordUsageCountUnsafeSupplier) {
        try {
            this.keywordUsageCount = (Integer)keywordUsageCountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The keyword's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this keyword is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Keyword)) {
            return false;
        }
        Keyword keyword = (Keyword)object;
        return Objects.equals(this.toString(), keyword.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywordUsageCount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywordUsageCount\": ");
            sb.append((Object)this.keywordUsageCount);
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Keyword._escape(this.name));
            sb.append("\"");
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (Keyword._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Keyword._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

