/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.internal.dto.v1_0.util;

import com.liferay.headless.admin.content.dto.v1_0.Status;
import com.liferay.headless.admin.content.dto.v1_0.Version;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VersionUtil {
    public static Version toVersion(final AcceptLanguage acceptLanguage, final JournalArticle journalArticle) {
        Set availableLocales = LanguageUtil.getAvailableLocales((long)journalArticle.getGroupId());
        final Stream availableLocalesStream = availableLocales.stream();
        final String statusLabel = WorkflowConstants.getStatusLabel((int)journalArticle.getStatus());
        return new Version(){
            {
                this.number = journalArticle.getVersion();
                this.status = new Status(){
                    {
                        this.code = journalArticle.getStatus();
                        this.label = statusLabel;
                        this.setLabel_i18n(() -> {
                            if (acceptLanguage.isAcceptAllLanguages()) {
                                return availableLocalesStream.collect(Collectors.toMap(LocaleUtil::toBCP47LanguageId, locale -> LanguageUtil.get((Locale)locale, (String)statusLabel)));
                            }
                            return null;
                        });
                    }
                };
            }
        };
    }
}

