/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.internal.dto.v1_0.converter;

import com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.content.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.content.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.content.internal.dto.v1_0.util.DisplayPageTemplateSettingsUtil;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DisplayPageTemplateDTOConverter.class, DTOConverter.class})
public class DisplayPageTemplateDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, DisplayPageTemplate> {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return DisplayPageTemplate.class.getSimpleName();
    }

    public DisplayPageTemplate toDTO(final DTOConverterContext dtoConverterContext, final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new DisplayPageTemplate(){
            {
                this.actions = dtoConverterContext.getActions();
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(DisplayPageTemplateDTOConverter.this._portal, dtoConverterContext.getUriInfoOptional(), DisplayPageTemplateDTOConverter.this._userLocalService.fetchUser(layoutPageTemplateEntry.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), Layout.class.getName(), layout.getPlid(), layout.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = layout.getCreateDate();
                this.dateModified = layout.getModifiedDate();
                this.displayPageTemplateKey = layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
                this.displayPageTemplateSettings = DisplayPageTemplateSettingsUtil.getDisplayPageTemplateSettings(dtoConverterContext, DisplayPageTemplateDTOConverter.this._infoItemServiceRegistry, layout, layoutPageTemplateEntry, DisplayPageTemplateDTOConverter.this._portal);
                this.markedAsDefault = layoutPageTemplateEntry.isDefaultTemplate();
                this.siteId = layout.getGroupId();
                this.title = layoutPageTemplateEntry.getName();
                this.uuid = layoutPageTemplateEntry.getUuid();
                this.setPageDefinition(() -> {
                    dtoConverterContext.setAttribute("layout", (Object)layout);
                    LayoutPageTemplateStructure layoutPageTemplateStructure = DisplayPageTemplateDTOConverter.this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
                    if (layoutPageTemplateStructure == null) {
                        return null;
                    }
                    DTOConverterRegistry dtoConverterRegistry = dtoConverterContext.getDTOConverterRegistry();
                    DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(LayoutStructure.class.getName());
                    if (dtoConverter == null) {
                        return null;
                    }
                    LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getDefaultSegmentsExperienceData());
                    return (PageDefinition)dtoConverter.toDTO(dtoConverterContext, (Object)layoutStructure);
                });
            }
        };
    }
}

