/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplateSettings;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a Display Page Template that has fields and is tied to a content type", value="DisplayPageTemplate")
@JsonFilter(value="Liferay.Vulcan")
@Schema(description="Represents a Display Page Template that has fields and is tied to a content type", requiredProperties={"title"})
@XmlRootElement(name="DisplayPageTemplate")
public class DisplayPageTemplate
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @GraphQLField(description="The list of languages the Display Page Template has a translation for.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The list of languages the Display Page Template has a translation for.") String[] availableLanguages;
    @GraphQLField(description="The Display Page Template's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The Display Page Template's creator.") Creator creator;
    @GraphQLField(description="The custom fields associated to the page that renders the Display Page Template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The custom fields associated to the page that renders the Display Page Template.") CustomField[] customFields;
    @GraphQLField(description="The Display Page Template's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The Display Page Template's creation date.") Date dateCreated;
    @GraphQLField(description="The last time any field of the Display Page Template was changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time any field of the Display Page Template was changed.") Date dateModified;
    @GraphQLField(description="The Display Page Template's external key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The Display Page Template's external key.") String displayPageTemplateKey;
    @GraphQLField(description="The Display Page Template's external key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The Display Page Template's external key.") DisplayPageTemplateSettings displayPageTemplateSettings;
    @GraphQLField(description="Specifies if the Display Page Template is the default one for the content type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Specifies if the Display Page Template is the default one for the content type.") Boolean markedAsDefault;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected PageDefinition pageDefinition;
    @GraphQLField(description="The ID of the site to which this Page Template is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this Page Template is scoped.") Long siteId;
    @GraphQLField(description="The title of the Display Page Template")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The title of the Display Page Template") @NotEmpty String title;
    @GraphQLField(description="A valid external identifier to reference this Display Page Template.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A valid external identifier to reference this Display Page Template.") String uuid;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplate", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static DisplayPageTemplate toDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.readValue(DisplayPageTemplate.class, (String)json);
    }

    public static DisplayPageTemplate unsafeToDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.unsafeReadValue(DisplayPageTemplate.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The list of languages the Display Page Template has a translation for.")
    public String[] getAvailableLanguages() {
        return this.availableLanguages;
    }

    public void setAvailableLanguages(String[] availableLanguages) {
        this.availableLanguages = availableLanguages;
    }

    @JsonIgnore
    public void setAvailableLanguages(UnsafeSupplier<String[], Exception> availableLanguagesUnsafeSupplier) {
        try {
            this.availableLanguages = (String[])availableLanguagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The Display Page Template's creator.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The custom fields associated to the page that renders the Display Page Template.")
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The Display Page Template's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time any field of the Display Page Template was changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The Display Page Template's external key.")
    public String getDisplayPageTemplateKey() {
        return this.displayPageTemplateKey;
    }

    public void setDisplayPageTemplateKey(String displayPageTemplateKey) {
        this.displayPageTemplateKey = displayPageTemplateKey;
    }

    @JsonIgnore
    public void setDisplayPageTemplateKey(UnsafeSupplier<String, Exception> displayPageTemplateKeyUnsafeSupplier) {
        try {
            this.displayPageTemplateKey = (String)displayPageTemplateKeyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The Display Page Template's external key.")
    @Valid
    public DisplayPageTemplateSettings getDisplayPageTemplateSettings() {
        return this.displayPageTemplateSettings;
    }

    public void setDisplayPageTemplateSettings(DisplayPageTemplateSettings displayPageTemplateSettings) {
        this.displayPageTemplateSettings = displayPageTemplateSettings;
    }

    @JsonIgnore
    public void setDisplayPageTemplateSettings(UnsafeSupplier<DisplayPageTemplateSettings, Exception> displayPageTemplateSettingsUnsafeSupplier) {
        try {
            this.displayPageTemplateSettings = (DisplayPageTemplateSettings)displayPageTemplateSettingsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Specifies if the Display Page Template is the default one for the content type.")
    public Boolean getMarkedAsDefault() {
        return this.markedAsDefault;
    }

    public void setMarkedAsDefault(Boolean markedAsDefault) {
        this.markedAsDefault = markedAsDefault;
    }

    @JsonIgnore
    public void setMarkedAsDefault(UnsafeSupplier<Boolean, Exception> markedAsDefaultUnsafeSupplier) {
        try {
            this.markedAsDefault = (Boolean)markedAsDefaultUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public void setPageDefinition(PageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
    }

    @JsonIgnore
    public void setPageDefinition(UnsafeSupplier<PageDefinition, Exception> pageDefinitionUnsafeSupplier) {
        try {
            this.pageDefinition = (PageDefinition)pageDefinitionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this Page Template is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The title of the Display Page Template")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        try {
            this.title = (String)titleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A valid external identifier to reference this Display Page Template.")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonIgnore
    public void setUuid(UnsafeSupplier<String, Exception> uuidUnsafeSupplier) {
        try {
            this.uuid = (String)uuidUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DisplayPageTemplate)) {
            return false;
        }
        DisplayPageTemplate displayPageTemplate = (DisplayPageTemplate)object;
        return Objects.equals(this.toString(), displayPageTemplate.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(DisplayPageTemplate._toJSON(this.actions));
        }
        if (this.availableLanguages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (i = 0; i < this.availableLanguages.length; ++i) {
                sb.append("\"");
                sb.append(DisplayPageTemplate._escape(this.availableLanguages[i]));
                sb.append("\"");
                if (i + 1 >= this.availableLanguages.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)this.creator);
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append((Object)this.customFields[i]);
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.displayPageTemplateKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayPageTemplateKey\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(this.displayPageTemplateKey));
            sb.append("\"");
        }
        if (this.displayPageTemplateSettings != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayPageTemplateSettings\": ");
            sb.append(String.valueOf(this.displayPageTemplateSettings));
        }
        if (this.markedAsDefault != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"markedAsDefault\": ");
            sb.append((Object)this.markedAsDefault);
        }
        if (this.pageDefinition != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageDefinition\": ");
            sb.append((Object)this.pageDefinition);
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.title != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(this.title));
            sb.append("\"");
        }
        if (this.uuid != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(this.uuid));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (DisplayPageTemplate._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(DisplayPageTemplate._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DisplayPageTemplate._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

