/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.address.internal.resource.v1_0;

import com.liferay.headless.admin.address.dto.v1_0.Region;
import com.liferay.headless.admin.address.internal.dto.v1_0.converter.RegionResourceDTOConverter;
import com.liferay.headless.admin.address.internal.resource.v1_0.BaseRegionResourceImpl;
import com.liferay.headless.admin.address.resource.v1_0.RegionResource;
import com.liferay.portal.kernel.model.RegionTable;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/region.properties"}, scope=ServiceScope.PROTOTYPE, service={RegionResource.class})
public class RegionResourceImpl
extends BaseRegionResourceImpl {
    private static final EntityModel _entityModel = () -> EntityModel.toEntityFieldsMap((EntityField[])new EntityField[]{new StringEntityField("name", locale -> "name"), new DoubleEntityField("position", locale -> "position")});
    @Reference
    private CountryService _countryService;
    @Reference
    private RegionResourceDTOConverter _regionResourceDTOConverter;
    @Reference
    private RegionService _regionService;

    @Override
    public void deleteRegion(Long regionId) throws Exception {
        this._regionService.deleteRegion(regionId.longValue());
    }

    @Override
    public Region getCountryRegionByRegionCode(Long countryId, String regionCode) throws Exception {
        return this._toRegion(this._regionService.getRegion(countryId.longValue(), regionCode));
    }

    @Override
    public Page<Region> getCountryRegionsPage(Long countryId, Boolean active, String search, Pagination pagination, Sort[] sorts) throws Exception {
        this._countryService.getCountry(countryId.longValue());
        BaseModelSearchResult baseModelSearchResult = this._regionService.searchRegions(this.contextCompany.getCompanyId(), active, search, LinkedHashMapBuilder.put((Object)"countryId", (Object)countryId).build(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts));
        return Page.of(this.transform(baseModelSearchResult.getBaseModels(), this::_toRegion), (Pagination)pagination, (long)baseModelSearchResult.getLength());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Region getRegion(Long regionId) throws Exception {
        return this._toRegion(this._regionService.getRegion(regionId.longValue()));
    }

    @Override
    public Page<Region> getRegionsPage(Boolean active, String search, Pagination pagination, Sort[] sorts) throws Exception {
        BaseModelSearchResult baseModelSearchResult = this._regionService.searchRegions(this.contextCompany.getCompanyId(), active, search, null, pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts));
        return Page.of(this.transform(baseModelSearchResult.getBaseModels(), this::_toRegion), (Pagination)pagination, (long)baseModelSearchResult.getLength());
    }

    @Override
    public Region postCountryRegion(Long countryId, Region region) throws Exception {
        return this._toRegion(this._regionService.addRegion(countryId.longValue(), GetterUtil.get((Object)region.getActive(), (boolean)true), region.getName(), GetterUtil.getDouble((Object)region.getPosition()), region.getRegionCode(), ServiceContextFactory.getInstance((String)Region.class.getName(), (HttpServletRequest)this.contextHttpServletRequest)));
    }

    @Override
    public Region putRegion(Long regionId, Region region) throws Exception {
        return this._toRegion(this._regionService.updateRegion(regionId.longValue(), GetterUtil.get((Object)region.getActive(), (boolean)true), region.getName(), GetterUtil.getDouble((Object)region.getPosition()), region.getRegionCode()));
    }

    private OrderByComparator<com.liferay.portal.kernel.model.Region> _toOrderByComparator(Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Sort sort : sorts) {
            objects.add(sort.getFieldName());
            objects.add(!sort.isReverse());
        }
        return OrderByComparatorFactoryUtil.create((String)RegionTable.INSTANCE.getTableName(), (Object[])objects.toArray(new Object[0]));
    }

    private Region _toRegion(com.liferay.portal.kernel.model.Region serviceBuilderRegion) throws Exception {
        return (Region)this._regionResourceDTOConverter.toDTO(serviceBuilderRegion);
    }
}

