/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.address.internal.resource.v1_0;

import com.liferay.headless.admin.address.dto.v1_0.Country;
import com.liferay.headless.admin.address.internal.dto.v1_0.converter.CountryResourceDTOConverter;
import com.liferay.headless.admin.address.internal.resource.v1_0.BaseCountryResourceImpl;
import com.liferay.headless.admin.address.resource.v1_0.CountryResource;
import com.liferay.portal.kernel.model.CountryTable;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/country.properties"}, scope=ServiceScope.PROTOTYPE, service={CountryResource.class})
public class CountryResourceImpl
extends BaseCountryResourceImpl {
    private static final EntityModel _entityModel = () -> EntityModel.toEntityFieldsMap((EntityField[])new EntityField[]{new StringEntityField("name", locale -> "name"), new DoubleEntityField("position", locale -> "position")});
    @Reference
    private CountryLocalService _countryLocalService;
    @Reference
    private CountryResourceDTOConverter _countryResourceDTOConverter;
    @Reference
    private CountryService _countryService;

    @Override
    public void deleteCountry(Long countryId) throws Exception {
        this._countryService.deleteCountry(countryId.longValue());
    }

    @Override
    public Page<Country> getCountriesPage(Boolean active, String search, Pagination pagination, Sort[] sorts) throws Exception {
        BaseModelSearchResult baseModelSearchResult = this._countryService.searchCountries(this.contextCompany.getCompanyId(), active, search, pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts));
        return Page.of(this.transform(baseModelSearchResult.getBaseModels(), this::_toCountry), (Pagination)pagination, (long)baseModelSearchResult.getLength());
    }

    @Override
    public Country getCountry(Long countryId) throws Exception {
        return this._toCountry(this._countryService.getCountry(countryId.longValue()));
    }

    @Override
    public Country getCountryByA2(String a2) throws Exception {
        return this._toCountry(this._countryService.getCountryByA2(this.contextCompany.getCompanyId(), a2));
    }

    @Override
    public Country getCountryByA3(String a3) throws Exception {
        return this._toCountry(this._countryService.getCountryByA3(this.contextCompany.getCompanyId(), a3));
    }

    @Override
    public Country getCountryByName(String name) throws Exception {
        return this._toCountry(this._countryService.getCountryByName(this.contextCompany.getCompanyId(), name));
    }

    @Override
    public Country getCountryByNumber(Integer number) throws Exception {
        return this._toCountry(this._countryService.getCountryByNumber(this.contextCompany.getCompanyId(), String.valueOf(number)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Country postCountry(Country country) throws Exception {
        com.liferay.portal.kernel.model.Country serviceBuilderCountry = this._countryService.addCountry(country.getA2(), country.getA3(), GetterUtil.getBoolean((Object)country.getActive(), (boolean)true), GetterUtil.getBoolean((Object)country.getBillingAllowed(), (boolean)true), String.valueOf(country.getIdd()), country.getName(), String.valueOf(country.getNumber()), GetterUtil.getDouble((Object)country.getPosition()), GetterUtil.getBoolean((Object)country.getShippingAllowed(), (boolean)true), GetterUtil.getBoolean((Object)country.getSubjectToVAT()), GetterUtil.getBoolean((Object)country.getZipRequired(), (boolean)true), ServiceContextFactory.getInstance((String)Country.class.getName(), (HttpServletRequest)this.contextHttpServletRequest));
        return this._toCountry(this._countryLocalService.updateGroupFilterEnabled(serviceBuilderCountry.getCountryId(), GetterUtil.getBoolean((Object)country.getGroupFilterEnabled())));
    }

    @Override
    public Country putCountry(Long countryId, Country country) throws Exception {
        com.liferay.portal.kernel.model.Country serviceBuilderCountry = this._countryService.updateCountry(countryId.longValue(), country.getA2(), country.getA3(), GetterUtil.getBoolean((Object)country.getActive(), (boolean)true), GetterUtil.getBoolean((Object)country.getBillingAllowed(), (boolean)true), String.valueOf(country.getIdd()), country.getName(), String.valueOf(country.getNumber()), GetterUtil.getDouble((Object)country.getPosition()), GetterUtil.getBoolean((Object)country.getShippingAllowed(), (boolean)true), GetterUtil.getBoolean((Object)country.getSubjectToVAT()));
        return this._toCountry(this._countryService.updateGroupFilterEnabled(serviceBuilderCountry.getCountryId(), GetterUtil.getBoolean((Object)country.getGroupFilterEnabled())));
    }

    private Country _toCountry(com.liferay.portal.kernel.model.Country serviceBuilderCountry) throws Exception {
        return (Country)this._countryResourceDTOConverter.toDTO(serviceBuilderCountry);
    }

    private OrderByComparator<com.liferay.portal.kernel.model.Country> _toOrderByComparator(Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Sort sort : sorts) {
            objects.add(sort.getFieldName());
            objects.add(!sort.isReverse());
        }
        return OrderByComparatorFactoryUtil.create((String)CountryTable.INSTANCE.getTableName(), (Object[])objects.toArray(new Object[0]));
    }
}

