/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.PluginContainer;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    public static String getArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return basePluginConvention.getArchivesBaseName();
    }

    public static File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    public static Thread[] getThreads() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        int threadCountGuess = threadGroup.activeCount();
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = threadGroup.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = threadGroup.enumerate(threads);
        }
        return threads;
    }

    public static boolean hasPlugin(Project project, Class<? extends Plugin<?>> pluginClass) {
        PluginContainer pluginContainer = project.getPlugins();
        return pluginContainer.hasPlugin(pluginClass);
    }

    public static boolean hasPlugin(Project project, String pluginId) {
        PluginContainer pluginContainer = project.getPlugins();
        return pluginContainer.hasPlugin(pluginId);
    }

    public static boolean isRunningInsideDaemon() {
        for (Thread thread : GradleUtil.getThreads()) {
            String name;
            if (thread == null || !(name = thread.getName()).startsWith("Daemon worker")) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> toStringMap(Map<String, ?> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = GradleUtil.toString(entry.getValue());
            stringMap.put(key, value);
        }
        return stringMap;
    }

    public static <P extends Plugin<? extends Project>> void withPlugin(Project project, Class<P> pluginClass, Action<P> action) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(pluginClass, action);
    }
}

