/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wsdd.builder;

import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;

public class WSDDBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_WSDD_TASK_NAME = "buildWSDD";
    public static final String CONFIGURATION_NAME = "wsddBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration wsddBuilderConfiguration = this.addConfigurationWSDDBuilder(project);
        this.addTaskBuildWSDD(project);
        this.configureTasksBuildWSDD(project, wsddBuilderConfiguration);
    }

    protected Configuration addConfigurationWSDDBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay WSDD Builder for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                WSDDBuilderPlugin.this.addDependenciesWSDDBuilder(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesWSDDBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.wsdd.builder", (String)"latest.release");
    }

    protected BuildWSDDTask addTaskBuildWSDD(Project project) {
        final BuildWSDDTask buildWSDDTask = (BuildWSDDTask)GradleUtil.addTask((Project)project, (String)BUILD_WSDD_TASK_NAME, BuildWSDDTask.class);
        buildWSDDTask.dependsOn(new Object[]{"compileJava"});
        buildWSDDTask.setBuilderClasspath(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Project project = buildWSDDTask.getProject();
                Task compileJavaTask = GradleUtil.getTask((Project)project, (String)"compileJava");
                TaskOutputs taskOutputs = compileJavaTask.getOutputs();
                FileCollection fileCollection = taskOutputs.getFiles();
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                fileCollection = fileCollection.plus(sourceSet.getCompileClasspath());
                fileCollection = fileCollection.plus(sourceSet.getRuntimeClasspath());
                return fileCollection.getAsPath();
            }
        });
        buildWSDDTask.setDescription("Runs Liferay WSDD Builder.");
        buildWSDDTask.setGroup("build");
        buildWSDDTask.setInputFile("service.xml");
        buildWSDDTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return WSDDBuilderPlugin.this.getResourcesDir(buildWSDDTask.getProject());
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                WSDDBuilderPlugin.this.configureTaskBuildWSDDForWarPlugin(buildWSDDTask);
            }
        });
        return buildWSDDTask;
    }

    protected void configureTaskBuildWSDDClasspath(BuildWSDDTask buildWSDDTask, FileCollection fileCollection) {
        buildWSDDTask.setClasspath(fileCollection);
    }

    protected void configureTaskBuildWSDDForWarPlugin(final BuildWSDDTask buildWSDDTask) {
        buildWSDDTask.setInputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(WSDDBuilderPlugin.this.getWebAppDir(buildWSDDTask.getProject()), "WEB-INF/service.xml");
            }
        });
        buildWSDDTask.setServerConfigFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(WSDDBuilderPlugin.this.getWebAppDir(buildWSDDTask.getProject()), "WEB-INF/server-config.wsdd");
            }
        });
    }

    protected void configureTasksBuildWSDD(Project project, final Configuration wsddBuilderCOnfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDDTask.class, (Action)new Action<BuildWSDDTask>(){

            public void execute(BuildWSDDTask buildWSDDTask) {
                WSDDBuilderPlugin.this.configureTaskBuildWSDDClasspath(buildWSDDTask, (FileCollection)wsddBuilderCOnfiguration);
            }
        });
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    protected File getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

