/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wsdd.builder;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.JavaExec;

public class BuildWSDDTask
extends JavaExec {
    private Object _builderClasspath;
    private Object _inputFile;
    private Object _outputDir;
    private Object _serverConfigFile = "server-config.wsdd";
    private Object _serviceNamespace = "Plugin";

    public BuildWSDDTask() {
        this.setMain("com.liferay.portal.tools.wsdd.builder.WSDDBuilder");
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    @Input
    public String getBuilderClasspath() {
        return GradleUtil.toString((Object)this._builderClasspath);
    }

    @InputFile
    public File getInputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._inputFile);
    }

    @Input
    public File getOutputDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputDir);
    }

    @Input
    public File getServerConfigFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._serverConfigFile);
    }

    @Input
    public String getServiceNamespace() {
        return GradleUtil.toString((Object)this._serviceNamespace);
    }

    public void setBuilderClasspath(Object builderClasspath) {
        this._builderClasspath = builderClasspath;
    }

    public void setInputFile(Object inputFile) {
        this._inputFile = inputFile;
    }

    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    public void setServerConfigFile(Object serverConfigFile) {
        this._serverConfigFile = serverConfigFile;
    }

    public void setServiceNamespace(Object serviceNamespace) {
        this._serviceNamespace = serviceNamespace;
    }

    protected List<String> getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("wsdd.class.path=" + this.getBuilderClasspath());
        args.add("wsdd.input.file=" + FileUtil.getAbsolutePath((File)this.getInputFile()));
        args.add("wsdd.output.path=" + FileUtil.getAbsolutePath((File)this.getOutputDir()) + "/");
        args.add("wsdd.server.config.file=" + FileUtil.getAbsolutePath((File)this.getServerConfigFile()));
        args.add("wsdd.service.namespace=" + this.getServiceNamespace());
        return args;
    }
}

