/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientExtension {
    public String description = "";
    public String id;
    public String name = "";
    public String projectName;
    public Map<String, Object> properties = Collections.emptyMap();
    public String sourceCodeURL = "";
    public String type;
    private final Map<String, Object> _typeSettings = new HashMap<String, Object>();

    @JsonAnySetter
    public void ignored(String name, Object value) {
        this._typeSettings.put(name, value);
    }

    public Map<String, Object> toJSONMap() throws Exception {
        Properties clientExtensionProperties = this._getClientExtensionProperties();
        String pid = clientExtensionProperties.getProperty(this.type);
        if (pid == null) {
            throw new Exception("Unable to find PID for type: " + this.type);
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("baseURL", "${portalURL}/o/" + this.projectName);
        configMap.put("description", this.description);
        configMap.put("dxp.lxc.liferay.com.virtualInstanceId", "default");
        configMap.put("name", this.name);
        configMap.put("properties", this._encode(this.properties));
        configMap.put("sourceCodeURL", this.sourceCodeURL);
        configMap.put("type", this.type);
        Set<Map.Entry<String, Object>> set = this._typeSettings.entrySet();
        set.forEach(entry -> {
            if (!pid.contains("CETConfiguration")) {
                configMap.put((String)entry.getKey(), entry.getValue());
            }
        });
        if ((this.type.equals("notificationType") || this.type.equals("oAuthApplicationHeadlessServer") || this.type.equals("oAuthApplicationUserAgent") || this.type.equals("workflowAction")) && this._typeSettings.get("homePageURL") == null) {
            this._typeSettings.put("homePageURL", "https://$[conf:ext.lxc.liferay.com.mainDomain]");
        }
        configMap.put("typeSettings", this._encode(this._typeSettings));
        jsonMap.put(pid + "~" + this.id, configMap);
        return jsonMap;
    }

    private List<String> _encode(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        Stream stream = set.stream();
        return stream.map(entry -> {
            Object value = entry.getValue();
            if (value instanceof List) {
                value = StringUtil.merge((Collection)((List)value), (String)"\n");
            }
            return StringBundler.concat((Object[])new Object[]{entry.getKey(), "=", value});
        }).collect(Collectors.toList());
    }

    private Properties _getClientExtensionProperties() throws Exception {
        Properties properties = new Properties();
        properties.load(ClientExtension.class.getResourceAsStream("client-extension.properties"));
        return properties;
    }
}

