/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.theme.builder.BuildThemeTask;
import com.liferay.gradle.plugins.theme.builder.ThemeBuilderPlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.War;
import org.gradle.api.tasks.bundling.Zip;

public class DesignPacksProjectConfigurator
extends BaseProjectConfigurator {
    public static final String BUILD_DESIGN_PACK_TASK_NAME = "buildDesignPack";
    protected static final String NAME = "design.pack";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private final boolean _defaultRepositoryEnabled;

    public DesignPacksProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.design.pack.default.repository.enabled", (boolean)true);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        GradleUtil.applyPlugin((Project)project, ThemeBuilderPlugin.class);
        this.configureLiferay(project, workspaceExtension);
        this._addDependenciesParentThemes(project);
        this._addDependenciesPortalCommonCSS(project);
        BuildThemeTask buildThemeTask = this._configureTaskBuildTheme(project);
        BuildCSSTask buildCSSTask = this._configureTaskBuildCSS(project);
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        war.setEnabled(false);
        Zip zip = this._addTaskBuildDesignPack(project, buildCSSTask, buildThemeTask);
        this._configureRootTaskDistBundle(project, zip);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (DesignPacksProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path packageJsonPath = dirPath.resolve("package.json");
                if (Files.exists(packageJsonPath, new LinkOption[0]) && DesignPacksProjectConfigurator.this._isLiferayDesignPack(packageJsonPath)) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    @Override
    protected String getDefaultRootDirName() {
        return "design-packs";
    }

    private void _addDependenciesParentThemes(Project project) {
        GradleUtil.addDependency((Project)project, (String)"parentThemes", (String)"com.liferay", (String)"com.liferay.frontend.theme.styled", (String)"latest.release");
        GradleUtil.addDependency((Project)project, (String)"parentThemes", (String)"com.liferay", (String)"com.liferay.frontend.theme.unstyled", (String)"latest.release");
        GradleUtil.addDependency((Project)project, (String)"parentThemes", (String)"com.liferay.plugins", (String)"classic-theme", (String)"latest.release");
    }

    private void _addDependenciesPortalCommonCSS(Project project) {
        GradleUtil.addDependency((Project)project, (String)"portalCommonCSS", (String)"com.liferay", (String)"com.liferay.frontend.css.common", (String)"latest.release", (boolean)false);
    }

    private Zip _addTaskBuildDesignPack(final Project project, BuildCSSTask buildCSSTask, final BuildThemeTask buildThemeTask) {
        Zip zip = (Zip)GradleUtil.addTask((Project)project, (String)BUILD_DESIGN_PACK_TASK_NAME, Zip.class);
        this._configureTaskDisableUpToDate((Task)zip);
        zip.dependsOn(new Object[]{buildCSSTask});
        zip.setDescription("Assembles design pack.");
        zip.setGroup("build");
        Property archiveBaseNameProperty = zip.getArchiveBaseName();
        archiveBaseNameProperty.set(project.provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName();
            }
        }));
        zip.into((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "";
            }
        }, (Closure)new Closure<Void>((Object)zip){

            public void doCall(CopySpec copySpec) {
                copySpec.from(new Object[]{new File(buildThemeTask.getOutputDir(), "/css/")});
                copySpec.setIncludeEmptyDirs(false);
                copySpec.include(new String[]{"*.css"});
            }
        });
        DirectoryProperty destinationDirectoryProperty = zip.getDestinationDirectory();
        destinationDirectoryProperty.set(new File(project.getProjectDir(), "dist"));
        buildCSSTask.finalizedBy(new Object[]{zip});
        return zip;
    }

    private void _configureRootTaskDistBundle(Project project, final Zip zip) {
        final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"deploy", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                Provider fileProvider = zip.getArchiveFile();
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{fileProvider});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{fileProvider});
            }
        });
    }

    private BuildCSSTask _configureTaskBuildCSS(Project project) {
        BuildCSSTask buildCSSTask = (BuildCSSTask)GradleUtil.getTask((Project)project, (String)"buildCSS");
        buildCSSTask.setOutputDirName((Object)".");
        return buildCSSTask;
    }

    private BuildThemeTask _configureTaskBuildTheme(final Project project) {
        final BuildThemeTask buildThemeTask = (BuildThemeTask)GradleUtil.getTask((Project)project, (String)"buildTheme");
        buildThemeTask.setDiffsDir((Object)project.file((Object)"src"));
        File packageJsonFile = project.file((Object)"package.json");
        if (!packageJsonFile.exists()) {
            return buildThemeTask;
        }
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonFile);
        Map liferayDesignPackMap = (Map)packageJsonMap.get("liferayDesignPack");
        String baseTheme = (String)liferayDesignPackMap.get("baseTheme");
        if (baseTheme.equals("styled") || baseTheme.equals("unstyled")) {
            baseTheme = "_" + baseTheme;
        }
        buildThemeTask.setParentName((Object)baseTheme);
        final HashMap allDependencyMap = new HashMap();
        Map dependenciesMap = (Map)packageJsonMap.get("dependencies");
        Map devDependenciesMap = (Map)packageJsonMap.get("devDependencies");
        if (Objects.nonNull(dependenciesMap)) {
            allDependencyMap.putAll(dependenciesMap);
        }
        if (Objects.nonNull(devDependenciesMap)) {
            allDependencyMap.putAll(devDependenciesMap);
        }
        if (!allDependencyMap.isEmpty()) {
            buildThemeTask.dependsOn(new Object[]{"npmInstall"});
            buildThemeTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    File nodeMoudleDir;
                    WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
                    String nodePackageManager = workspaceExtension.getNodePackageManager();
                    if (Objects.equals(nodePackageManager, "yarn")) {
                        Project rootProject = project.getRootProject();
                        nodeMoudleDir = rootProject.file((Object)"node_modules");
                    } else {
                        nodeMoudleDir = project.file((Object)"node_modules");
                    }
                    for (final String key : allDependencyMap.keySet()) {
                        final File dependencyDir = new File(nodeMoudleDir, key);
                        if (!dependencyDir.exists()) continue;
                        project.copy((Action)new Action<CopySpec>(){

                            public void execute(CopySpec copySpec) {
                                copySpec.from(new Object[]{dependencyDir});
                                copySpec.into((Object)(buildThemeTask.getOutputDir() + "/css/" + key));
                                copySpec.setIncludeEmptyDirs(false);
                            }
                        });
                    }
                }
            });
        }
        return buildThemeTask;
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.dependsOn(new Object[]{"build"});
        copy.from(new Object[]{this._getZipFile(project)});
    }

    private void _configureTaskDisableUpToDate(Task task) {
        TaskOutputs taskOutputs = task.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }

    private Map<String, Object> _getPackageJsonMap(File packageJsonFile) {
        if (!packageJsonFile.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(packageJsonFile);
    }

    private File _getZipFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".zip"));
    }

    private boolean _isLiferayDesignPack(Path packageJsonPath) {
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonPath.toFile());
        Map liferayTheme = (Map)packageJsonMap.get("liferayDesignPack");
        return liferayTheme != null;
    }
}

