/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.War;

public class WarsProjectConfigurator
extends BaseProjectConfigurator {
    protected static final String NAME = "wars";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private boolean _defaultRepositoryEnabled;

    public WarsProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.wars.default.repository.enabled", (boolean)true);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
        this._configureTaskProcessResources(project);
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        this._configureBaseTaskDeploy(war, workspaceExtension);
        this.addTaskDockerDeploy(project, war, workspaceExtension);
        this._configureRootTaskDistBundle(war);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (Files.isDirectory(dirPath.resolve("src/main/webapp"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path dirNamePath = dirPath.getFileName();
                if (WarsProjectConfigurator.this.isExcludedDirName(dirNamePath.toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _configureBaseTaskDeploy(War war, final WorkspaceExtension workspaceExtension) {
        Project project = war.getProject();
        project.afterEvaluate(curProject -> {
            TaskContainer taskContainer = curProject.getTasks();
            taskContainer.named("deploy", Copy.class, copy -> {
                copy.from(new Object[]{war});
                copy.into((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(workspaceExtension.getHomeDir(), "deploy");
                    }
                });
                copy.setDescription("Assembles the project and deploys it to Liferay.");
                copy.setGroup("build");
            });
        });
    }

    private void _configureRootTaskDistBundle(final War war) {
        Project project = war.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.into((Object)"osgi/war", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.from(new Object[]{war});
            }
        });
    }

    private void _configureTaskProcessResources(Project project) {
        project.afterEvaluate(curProject -> {
            Copy copy;
            if (GradleUtil.hasTask(curProject, "buildCSS") && (copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources")) != null) {
                copy.dependsOn(new Object[]{"buildCSS"});
                copy.exclude(new String[]{"**/*.css"});
                copy.exclude(new String[]{"**/*.scss"});
                copy.filesMatching("**/.sass-cache/", fileCopyDetails -> {
                    String path = fileCopyDetails.getPath();
                    fileCopyDetails.setPath(path.replace(".sass-cache/", ""));
                });
                copy.setIncludeEmptyDirs(false);
            }
        });
    }
}

