/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wedeploy;

import com.liferay.gradle.plugins.wedeploy.WeDeployPlugin;
import com.liferay.gradle.plugins.wedeploy.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;

public class WeDeploySettingsPlugin
implements Plugin<Settings> {
    public static final String PROJECT_PATH_PREFIX_PROPERTY_NAME = "project.path.prefix";

    public void apply(Settings settings) {
        try {
            this._apply(settings);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
    }

    private void _apply(Settings settings) throws IOException {
        final Set<String> projectPaths = this._includeProjects(settings);
        Gradle gradle = settings.getGradle();
        gradle.beforeProject((Closure)new Closure<Void>((Object)settings){

            public void doCall(Project project) {
                if (projectPaths.contains(project.getPath())) {
                    GradleUtil.applyPlugin((Project)project, WeDeployPlugin.class);
                }
            }
        });
    }

    private String _getProjectPathPrefix(Settings settings) {
        String projectPathPrefix = GradleUtil.getProperty((ExtensionAware)settings, (String)PROJECT_PATH_PREFIX_PROPERTY_NAME, (String)"");
        if (Validator.isNotNull((String)projectPathPrefix)) {
            if (projectPathPrefix.charAt(0) != ':') {
                projectPathPrefix = ":" + projectPathPrefix;
            }
            if (projectPathPrefix.charAt(projectPathPrefix.length() - 1) == ':') {
                projectPathPrefix = projectPathPrefix.substring(0, projectPathPrefix.length() - 1);
            }
        }
        return projectPathPrefix;
    }

    private String _includeProject(Settings settings, Path dirPath, Path rootDirPath, String projectPathPrefix) {
        String projectPath = String.valueOf(rootDirPath.relativize(dirPath));
        projectPath = projectPathPrefix + ":" + projectPath.replace(File.separatorChar, ':');
        settings.include(new String[]{projectPath});
        ProjectDescriptor projectDescriptor = settings.findProject(projectPath);
        projectDescriptor.setProjectDir(dirPath.toFile());
        return projectPath;
    }

    private Set<String> _includeProjects(final Settings settings) throws IOException {
        final String projectPathPrefix = this._getProjectPathPrefix(settings);
        final HashSet<String> projectPaths = new HashSet<String>();
        File rootDir = settings.getRootDir();
        final Path rootDirPath = rootDir.toPath();
        Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path wedeployJSONPath = dirPath.resolve("wedeploy.json");
                if (Files.notExists(wedeployJSONPath, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                String projectPath = WeDeploySettingsPlugin.this._includeProject(settings, dirPath, rootDirPath, projectPathPrefix);
                projectPaths.add(projectPath);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return projectPaths;
    }
}

