/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.upgrade.table.builder;

import com.liferay.gradle.plugins.upgrade.table.builder.BuildUpgradeTableTask;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class UpgradeTableBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_UPGRADE_TABLE_TASK_NAME = "buildUpgradeTable";
    public static final String CONFIGURATION_NAME = "upgradeTableBuilder";

    public void apply(Project project) {
        Configuration upgradeTableBuilderConfiguration = this._addConfigurationUpgradeTableBuilder(project);
        this._addTaskBuildUpgradeTable(project);
        this._configureTasksBuildUpgradeTable(project, upgradeTableBuilderConfiguration);
    }

    private Configuration _addConfigurationUpgradeTableBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                UpgradeTableBuilderPlugin.this._addDependenciesUpgradeTableBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay Upgrade Table Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesUpgradeTableBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.upgrade.table.builder", (String)"latest.release");
    }

    private BuildUpgradeTableTask _addTaskBuildUpgradeTable(Project project) {
        BuildUpgradeTableTask buildUpgradeTableTask = (BuildUpgradeTableTask)GradleUtil.addTask((Project)project, (String)BUILD_UPGRADE_TABLE_TASK_NAME, BuildUpgradeTableTask.class);
        buildUpgradeTableTask.setBaseDir(project.getProjectDir());
        buildUpgradeTableTask.setDescription("Runs Liferay Upgrade Table Builder to build upgrade tables.");
        buildUpgradeTableTask.setGroup("build");
        return buildUpgradeTableTask;
    }

    private void _configureTaskBuildUpgradeTableClasspath(BuildUpgradeTableTask buildUpgradeTableTask, FileCollection fileCollection) {
        buildUpgradeTableTask.setClasspath(fileCollection);
    }

    private void _configureTasksBuildUpgradeTable(Project project, final Configuration upgradeTableBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildUpgradeTableTask.class, (Action)new Action<BuildUpgradeTableTask>(){

            public void execute(BuildUpgradeTableTask buildUpgradeTableTask) {
                UpgradeTableBuilderPlugin.this._configureTaskBuildUpgradeTableClasspath(buildUpgradeTableTask, (FileCollection)upgradeTableBuilderConfiguration);
            }
        });
    }
}

