/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tlddoc.builder;

import com.liferay.gradle.plugins.tlddoc.builder.task.TLDDocTask;
import com.liferay.gradle.plugins.tlddoc.builder.task.ValidateSchemaTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class TLDDocBuilderPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "tlddoc";
    public static final String COPY_TLDDOC_RESOURCES_TASK_NAME = "copyTLDDocResources";
    public static final String TLDDOC_TASK_NAME = "tlddoc";
    public static final String VALIDATE_TLD_TASK_NAME = "validateTLD";
    public static final String XML_PARSER_CONFIGURATION_NAME = "xmlParser";

    public void apply(Project project) {
        Configuration tlddocConfiguration = TLDDocBuilderPlugin.addConfigurationTLDDoc(project);
        ValidateSchemaTask validateTLDTask = this._addTaskValidateTLD(project);
        Copy copyTLDDocResourcesTask = this._addTaskCopyTLDDocResources(project);
        this._addTaskTLDDoc(copyTLDDocResourcesTask, validateTLDTask);
        this._configureTasksTLDDoc(project, tlddocConfiguration);
    }

    protected static Configuration addConfigurationTLDDoc(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"tlddoc");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TLDDocBuilderPlugin._addDependenciesTLDDoc(project);
            }
        });
        configuration.setDescription("Configures Tag Library Documentation Generator for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private static void _addDependenciesTLDDoc(Project project) {
        GradleUtil.addDependency((Project)project, (String)"tlddoc", (String)"taglibrarydoc", (String)"tlddoc", (String)"1.3");
    }

    private Copy _addTaskCopyTLDDocResources(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_TLDDOC_RESOURCES_TASK_NAME, Copy.class);
        copy.from(new Object[]{"src/main/tlddoc"});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                TLDDocTask tldDocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
                return tldDocTask.getDestinationDir();
            }
        });
        copy.setDescription("Copies tag library documentation resources.");
        return copy;
    }

    private TLDDocTask _addTaskTLDDoc(Copy copyTLDDocResourcesTask, ValidateSchemaTask validateTLDTask) {
        Project project = copyTLDDocResourcesTask.getProject();
        final TLDDocTask tldDocTask = (TLDDocTask)GradleUtil.addTask((Project)project, (String)"tlddoc", TLDDocTask.class);
        tldDocTask.dependsOn(new Object[]{copyTLDDocResourcesTask, validateTLDTask});
        tldDocTask.setDescription("Generates tag library documentation.");
        tldDocTask.setGroup("documentation");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TLDDocBuilderPlugin.this._configureTaskTLDDocForJavaPlugin(tldDocTask);
            }
        });
        return tldDocTask;
    }

    private ValidateSchemaTask _addTaskValidateTLD(Project project) {
        final ValidateSchemaTask validateSchemaTask = (ValidateSchemaTask)GradleUtil.addTask((Project)project, (String)VALIDATE_TLD_TASK_NAME, ValidateSchemaTask.class);
        validateSchemaTask.setDescription("Validates TLD files.");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TLDDocBuilderPlugin.this._configureTaskValidateSchemaForJavaPlugin(validateSchemaTask);
            }
        });
        return validateSchemaTask;
    }

    private void _configureTasksTLDDoc(Project project, final Configuration tlddocConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(TLDDocTask.class, (Action)new Action<TLDDocTask>(){

            public void execute(TLDDocTask tldDocTask) {
                TLDDocBuilderPlugin.this._configureTaskTLDDocClasspath(tldDocTask, (FileCollection)tlddocConfiguration);
            }
        });
    }

    private void _configureTaskTLDDocClasspath(TLDDocTask tldDocTask, FileCollection fileCollection) {
        tldDocTask.setClasspath(fileCollection);
    }

    private void _configureTaskTLDDocForJavaPlugin(TLDDocTask tldDocTask) {
        final Project project = tldDocTask.getProject();
        tldDocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
                return new File(javaPluginConvention.getDocsDir(), "tlddoc");
            }
        });
        tldDocTask.setIncludes(Collections.singleton("**/*.tld"));
        tldDocTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return TLDDocBuilderPlugin.this._getResourceDirs(project);
            }
        });
    }

    private void _configureTaskValidateSchemaForJavaPlugin(ValidateSchemaTask validateSchemaTask) {
        final Project project = validateSchemaTask.getProject();
        validateSchemaTask.setIncludes(Collections.singleton("**/*.tld"));
        validateSchemaTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return TLDDocBuilderPlugin.this._getResourceDirs(project);
            }
        });
    }

    private Iterable<File> _getResourceDirs(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getResources();
        return sourceDirectorySet.getSrcDirs();
    }
}

