/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tlddoc.builder;

import com.liferay.gradle.plugins.tlddoc.builder.tasks.TLDDocTask;
import com.liferay.gradle.plugins.tlddoc.builder.tasks.ValidateSchemaTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class TLDDocBuilderPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "tlddoc";
    public static final String COPY_TLDDOC_RESOURCES_TASK_NAME = "copyTLDDocResources";
    public static final String TLDDOC_TASK_NAME = "tlddoc";
    public static final String VALIDATE_TLD_TASK_NAME = "validateTLD";
    public static final String XML_PARSER_CONFIGURATION_NAME = "xmlParser";

    public void apply(Project project) {
        Configuration tlddocConfiguration = TLDDocBuilderPlugin.addConfigurationTLDDoc(project);
        Configuration xmlParserConfiguration = this._addConfigurationXMLParser(project);
        ValidateSchemaTask validateTLDTask = this._addTaskValidateTLD(project, "org.xmlresolver.tools.ResolvingXMLReader", (FileCollection)xmlParserConfiguration);
        Copy copyTLDDocResourcesTask = this._addTaskCopyTLDDocResources(project);
        this._addTaskTLDDoc(copyTLDDocResourcesTask, validateTLDTask);
        this._configureTasksTLDDoc(project, tlddocConfiguration);
    }

    protected static Configuration addConfigurationTLDDoc(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"tlddoc");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TLDDocBuilderPlugin._addDependenciesTLDDoc(project);
            }
        });
        configuration.setDescription("Configures Tag Library Documentation Generator for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private static void _addDependenciesTLDDoc(Project project) {
        GradleUtil.addDependency((Project)project, (String)"tlddoc", (String)"taglibrarydoc", (String)"tlddoc", (String)"1.3");
    }

    private static void _addDependenciesXMLParser(Project project) {
        GradleUtil.addDependency((Project)project, (String)XML_PARSER_CONFIGURATION_NAME, (String)"org.xmlresolver", (String)"xmlresolver", (String)"0.12.5");
    }

    private Configuration _addConfigurationXMLParser(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)XML_PARSER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TLDDocBuilderPlugin._addDependenciesXMLParser(project);
            }
        });
        configuration.setDescription("Configures the XML Parser to use during schema validation.");
        configuration.setVisible(false);
        return configuration;
    }

    private Copy _addTaskCopyTLDDocResources(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_TLDDOC_RESOURCES_TASK_NAME, Copy.class);
        copy.from(new Object[]{"src/main/tlddoc"});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
                return tlddocTask.getDestinationDir();
            }
        });
        copy.setDescription("Copies tag library documentation resources.");
        return copy;
    }

    private TLDDocTask _addTaskTLDDoc(Copy copyTLDDocResourcesTask, ValidateSchemaTask validateTLDTask) {
        Project project = copyTLDDocResourcesTask.getProject();
        final TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.addTask((Project)project, (String)"tlddoc", TLDDocTask.class);
        tlddocTask.dependsOn(new Object[]{copyTLDDocResourcesTask, validateTLDTask});
        tlddocTask.setDescription("Generates tag library documentation.");
        tlddocTask.setGroup("documentation");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TLDDocBuilderPlugin.this._configureTaskTLDDocForJavaPlugin(tlddocTask);
            }
        });
        return tlddocTask;
    }

    private ValidateSchemaTask _addTaskValidateTLD(Project project, String xmlParserClassName, FileCollection xmlParserClasspath) {
        final ValidateSchemaTask validateSchemaTask = (ValidateSchemaTask)GradleUtil.addTask((Project)project, (String)VALIDATE_TLD_TASK_NAME, ValidateSchemaTask.class);
        validateSchemaTask.setDescription("Validates TLD files.");
        validateSchemaTask.setXMLParserClassName(xmlParserClassName);
        validateSchemaTask.setXMLParserClasspath(xmlParserClasspath);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TLDDocBuilderPlugin.this._configureTaskValidateSchemaForJavaPlugin(validateSchemaTask);
            }
        });
        return validateSchemaTask;
    }

    private void _configureTasksTLDDoc(Project project, final Configuration tlddocConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(TLDDocTask.class, (Action)new Action<TLDDocTask>(){

            public void execute(TLDDocTask tlddocTask) {
                TLDDocBuilderPlugin.this._configureTaskTLDDocClasspath(tlddocTask, (FileCollection)tlddocConfiguration);
            }
        });
    }

    private void _configureTaskTLDDocClasspath(TLDDocTask tlddocTask, FileCollection fileCollection) {
        tlddocTask.setClasspath(fileCollection);
    }

    private void _configureTaskTLDDocForJavaPlugin(TLDDocTask tlddocTask) {
        final Project project = tlddocTask.getProject();
        tlddocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
                return new File(javaPluginConvention.getDocsDir(), "tlddoc");
            }
        });
        tlddocTask.setIncludes(Collections.singleton("**/*.tld"));
        tlddocTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return TLDDocBuilderPlugin.this._getResourceDirs(project);
            }
        });
    }

    private void _configureTaskValidateSchemaForJavaPlugin(ValidateSchemaTask validateSchemaTask) {
        final Project project = validateSchemaTask.getProject();
        validateSchemaTask.setIncludes(Collections.singleton("**/*.tld"));
        validateSchemaTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return TLDDocBuilderPlugin.this._getResourceDirs(project);
            }
        });
    }

    private Iterable<File> _getResourceDirs(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getResources();
        return sourceDirectorySet.getSrcDirs();
    }
}

