/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.theme.builder;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class BuildThemeTask
extends JavaExec {
    private Object _diffsDir;
    private Object _outputDir;
    private Object _parentDir;
    private Object _parentFile;
    private Object _parentName;
    private Object _templateExtension;
    private Object _themeName;
    private Object _unstyledDir;
    private Object _unstyledFile;

    public BuildThemeTask() {
        this.setMain("com.liferay.portal.tools.theme.builder.ThemeBuilder");
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getDiffsDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._diffsDir);
    }

    @OutputDirectory
    public File getOutputDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputDir);
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getParentDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._parentDir);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getParentFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._parentFile);
    }

    @Input
    @Optional
    public String getParentName() {
        return GradleUtil.toString((Object)this._parentName);
    }

    @Input
    public String getTemplateExtension() {
        return GradleUtil.toString((Object)this._templateExtension);
    }

    @Input
    public String getThemeName() {
        return GradleUtil.toString((Object)this._themeName);
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getUnstyledDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._unstyledDir);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getUnstyledFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._unstyledFile);
    }

    public void setDiffsDir(Object diffsDir) {
        this._diffsDir = diffsDir;
    }

    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    public void setParentDir(Object parentDir) {
        this._parentDir = parentDir;
    }

    public void setParentFile(Object parentFile) {
        this._parentFile = parentFile;
    }

    public void setParentName(Object parentName) {
        this._parentName = parentName;
    }

    public void setTemplateExtension(Object templateExtension) {
        this._templateExtension = templateExtension;
    }

    public void setThemeName(Object themeName) {
        this._themeName = themeName;
    }

    public void setUnstyledDir(Object unstyledDir) {
        this._unstyledDir = unstyledDir;
    }

    public void setUnstyledFile(Object unstyledFile) {
        this._unstyledFile = unstyledFile;
    }

    private static void _addArg(List<String> args, String name, File file) {
        if (file != null) {
            BuildThemeTask._addArg(args, name, file.getAbsolutePath());
        }
    }

    private static void _addArg(List<String> args, String name, String value) {
        if (Validator.isNotNull((String)value)) {
            args.add(name);
            args.add(value);
        }
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        BuildThemeTask._addArg(args, "--diffs-dir", this.getDiffsDir());
        BuildThemeTask._addArg(args, "--name", this.getThemeName());
        BuildThemeTask._addArg(args, "--output-dir", this.getOutputDir());
        BuildThemeTask._addArg(args, "--parent-name", this.getParentName());
        BuildThemeTask._addArg(args, "--parent-path", this._getParentPath());
        BuildThemeTask._addArg(args, "--template-extension", this.getTemplateExtension());
        BuildThemeTask._addArg(args, "--unstyled-path", this._getUnstyledPath());
        return args;
    }

    private File _getParentPath() {
        File parentPath = this.getParentDir();
        if (parentPath == null) {
            parentPath = this.getParentFile();
        }
        return parentPath;
    }

    private File _getUnstyledPath() {
        File unstyledPath = this.getUnstyledDir();
        if (unstyledPath == null) {
            unstyledPath = this.getUnstyledFile();
        }
        return unstyledPath;
    }
}

