/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.tasks.JmxRemotePortSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ManagerSpec;
import com.liferay.gradle.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class SetUpArquillianTask
extends DefaultTask
implements JmxRemotePortSpec,
ManagerSpec {
    private Object _jmxRemotePort;
    private Object _managerPassword;
    private Object _managerUserName;
    private Object _outputDir;

    public SetUpArquillianTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File outputFile = SetUpArquillianTask.this._getOutputFile();
                return !outputFile.exists();
            }
        });
    }

    @Override
    @Input
    public int getJmxRemotePort() {
        return GradleUtil.toInteger((Object)this._jmxRemotePort);
    }

    @Override
    @Input
    public String getManagerPassword() {
        return GradleUtil.toString((Object)this._managerPassword);
    }

    @Override
    @Input
    public String getManagerUserName() {
        return GradleUtil.toString((Object)this._managerUserName);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getOutputDir() {
        return GradleUtil.toFile(this.getProject(), this._outputDir);
    }

    @Override
    public void setJmxRemotePort(Object jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    @Override
    public void setManagerPassword(Object managerPassword) {
        this._managerPassword = managerPassword;
    }

    @Override
    public void setManagerUserName(Object managerUserName) {
        this._managerUserName = managerUserName;
    }

    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    @TaskAction
    public void setUpArquillian() throws IOException {
        File outputFile = this._getOutputFile();
        String xml = FileUtil.read((String)"com/liferay/gradle/plugins/test/integration/dependencies/arquillian.xml");
        xml = xml.replace("${app.server.tomcat.manager.password}", this.getManagerPassword());
        xml = xml.replace("${app.server.tomcat.manager.user}", this.getManagerUserName());
        xml = xml.replace("${jmx.remote.port}", String.valueOf(this.getJmxRemotePort()));
        Files.write(outputFile.toPath(), xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private File _getOutputFile() {
        return new File(this.getOutputDir(), "arquillian.xml");
    }
}

