/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.internal.util.StringUtil;
import com.liferay.gradle.plugins.test.integration.tasks.ManagerSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ModuleFrameworkBaseDirSpec;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.ExcludeExistingFileAction;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.xml.DOMBuilder;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.VersionNumber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@CacheableTask
public class SetUpTestableTomcatTask
extends DefaultTask
implements ManagerSpec,
ModuleFrameworkBaseDirSpec {
    private static final String[] _TOMCAT_USERS_ROLE_NAMES = new String[]{"manager-gui", "manager-jmx", "manager-script", "manager-status", "tomcat"};
    private Object _aspectJAgent;
    private Object _aspectJConfiguration;
    private boolean _debugLogging;
    private Object _dir;
    private Object _jaCoCoAgentConfiguration;
    private Object _jaCoCoAgentFile;
    private Object _managerPassword;
    private Object _managerUserName;
    private Object _moduleFrameworkBaseDir;
    private boolean _overwriteTestModules;
    private final DateFormat _timestampDateFormat = new SimpleDateFormat("yyyyMMddkkmmssSSS");
    private Object _zipUrl = new Callable<String>(){

        @Override
        public String call() throws Exception {
            File dir = SetUpTestableTomcatTask.this.getDir();
            String dirName = dir.getName();
            int start = StringUtil.indexOfDigit(dirName);
            if (start < 0) {
                return null;
            }
            VersionNumber versionNumber = VersionNumber.parse((String)dirName.substring(start));
            if (versionNumber == VersionNumber.UNKNOWN) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("http://archive.apache.org/dist/tomcat/tomcat-");
            sb.append(versionNumber.getMajor());
            sb.append("/v");
            sb.append(versionNumber);
            sb.append("/bin/apache-tomcat-");
            sb.append(versionNumber);
            sb.append(".zip");
            return sb.toString();
        }
    };

    @Input
    @Optional
    public String getAspectJAgent() {
        return GradleUtil.toString((Object)this._aspectJAgent);
    }

    @Input
    @Optional
    public String getAspectJConfiguration() {
        return GradleUtil.toString((Object)this._aspectJConfiguration);
    }

    public File getBinDir() {
        return new File(this.getDir(), "bin");
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getDir() {
        return GradleUtil.toFile(this.getProject(), this._dir);
    }

    @Input
    @Optional
    public String getJaCoCoAgentConfiguration() {
        return GradleUtil.toString((Object)this._jaCoCoAgentConfiguration);
    }

    @Input
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getJaCoCoAgentFile() {
        return GradleUtil.toFile(this.getProject(), this._jaCoCoAgentFile);
    }

    @Override
    @Input
    public String getManagerPassword() {
        return GradleUtil.toString((Object)this._managerPassword);
    }

    @Override
    @Input
    public String getManagerUserName() {
        return GradleUtil.toString((Object)this._managerUserName);
    }

    @Override
    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getModuleFrameworkBaseDir() {
        return GradleUtil.toFile(this.getProject(), this._moduleFrameworkBaseDir);
    }

    @Input
    public String getZipUrl() {
        return GradleUtil.toString((Object)this._zipUrl);
    }

    @Input
    public boolean isDebugLogging() {
        return this._debugLogging;
    }

    @Input
    public boolean isOverwriteTestModules() {
        return this._overwriteTestModules;
    }

    public void setAspectJAgent(Object aspectJAgent) {
        this._aspectJAgent = aspectJAgent;
    }

    public void setAspectJConfiguration(Object aspectJConfiguration) {
        this._aspectJConfiguration = aspectJConfiguration;
    }

    public void setDebugLogging(boolean debugLogging) {
        this._debugLogging = debugLogging;
    }

    public void setDir(Object dir) {
        this._dir = dir;
    }

    public void setJaCoCoAgentConfiguration(Object jaCoCoAgentConfiguration) {
        this._jaCoCoAgentConfiguration = jaCoCoAgentConfiguration;
    }

    public void setJaCoCoAgentFile(Object jaCoCoAgentFile) {
        this._jaCoCoAgentFile = jaCoCoAgentFile;
    }

    @Override
    public void setManagerPassword(Object managerPassword) {
        this._managerPassword = managerPassword;
    }

    @Override
    public void setManagerUserName(Object managerUserName) {
        this._managerUserName = managerUserName;
    }

    @Override
    public void setModuleFrameworkBaseDir(Object moduleFrameworkBaseDir) {
        this._moduleFrameworkBaseDir = moduleFrameworkBaseDir;
    }

    public void setOverwriteTestModules(boolean overwriteTestModules) {
        this._overwriteTestModules = overwriteTestModules;
    }

    @TaskAction
    public void setUpTestableTomcat() throws Exception {
        this._setUpFilePermissions();
        this._setUpLogging();
        this._setUpManager();
        this._setUpOsgiModules();
        this._setUpSetEnv();
    }

    public void setZipUrl(Object zipUrl) {
        this._zipUrl = zipUrl;
    }

    private boolean _contains(String fileName, String s) throws Exception {
        File file = new File(this.getDir(), fileName);
        String fileContent = new String(Files.readAllBytes(file.toPath()));
        return fileContent.contains(s);
    }

    private PrintWriter _getAppendPrintWriter(String fileName) throws IOException {
        File file = new File(this.getDir(), fileName);
        return new PrintWriter(Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.WRITE));
    }

    private void _setUpAspectJ() throws Exception {
        String aspectJAgent = this.getAspectJAgent();
        if (Validator.isNotNull((String)aspectJAgent) && !this._contains("bin/setenv.sh", aspectJAgent)) {
            try (PrintWriter printWriter = this._getAppendPrintWriter("bin/setenv.sh");){
                printWriter.println();
                printWriter.print("CATALINA_OPTS=\"${CATALINA_OPTS} ");
                printWriter.print(aspectJAgent);
                printWriter.print(" -Dorg.aspectj.weaver.loadtime.configuration=");
                String aspectJConfiguration = this.getAspectJConfiguration();
                if (Validator.isNotNull((String)aspectJConfiguration)) {
                    printWriter.print(aspectJConfiguration);
                }
                printWriter.println("\"");
            }
        }
    }

    private void _setUpFilePermissions() {
        if (OSDetector.isWindows()) {
            return;
        }
        File binDir = this.getBinDir();
        for (File file : binDir.listFiles()) {
            String fileName;
            if (!file.isFile() || !(fileName = file.getName()).endsWith(".sh")) continue;
            file.setExecutable(true);
        }
    }

    private void _setUpJaCoCo() throws Exception {
        File jaCoCoAgentFile = this.getJaCoCoAgentFile();
        File targetJaCoCoAgentFile = new File(this.getDir(), "bin/jacocoagent.jar");
        if (jaCoCoAgentFile != null && !targetJaCoCoAgentFile.exists()) {
            Files.copy(jaCoCoAgentFile.toPath(), targetJaCoCoAgentFile.toPath(), new CopyOption[0]);
        }
        String jaCoCoJvmArg = "-javaagent:" + targetJaCoCoAgentFile.getAbsolutePath();
        if (this._jaCoCoAgentConfiguration != null) {
            jaCoCoJvmArg = jaCoCoJvmArg + this._jaCoCoAgentConfiguration;
        }
        if (!this._contains("bin/setenv.sh", jaCoCoJvmArg)) {
            try (PrintWriter printWriter = this._getAppendPrintWriter("bin/setenv.sh");){
                printWriter.println();
                printWriter.println("if [ \"$1\" = \"jacoco\" ]");
                printWriter.println("then");
                printWriter.print("    JACOCO_OPTS=\"");
                printWriter.print(jaCoCoJvmArg);
                printWriter.println("\"");
                printWriter.println("    CATALINA_OPTS=\"${CATALINA_OPTS} ${JACOCO_OPTS}\"");
                printWriter.println("    shift");
                printWriter.println("fi");
            }
        }
    }

    private void _setUpJpda() throws Exception {
        if (!this._contains("bin/setenv.sh", "JPDA_ADDRESS")) {
            try (PrintWriter printWriter = this._getAppendPrintWriter("bin/setenv.sh");){
                printWriter.println();
                printWriter.println("JPDA_ADDRESS=\"8000\"");
            }
        }
    }

    private void _setUpLogging() throws Exception {
        if (!this.isDebugLogging() || this._contains("conf/Logging.properties", "org.apache.catalina.level")) {
            return;
        }
        try (PrintWriter printWriter = this._getAppendPrintWriter("conf/Logging.properties");){
            printWriter.println("org.apache.catalina.level=ALL");
            printWriter.println();
            printWriter.println("org.apache.catalina.loader.WebappClassLoader.level=INFO");
            printWriter.println("org.apache.catalina.loader.WebappLoader.level=INFO");
            printWriter.println("org.apache.catalina.startup.ClassLoaderFactory.level=INFO");
        }
    }

    private void _setUpManager() throws Exception {
        final File managerDir = new File(this.getDir(), "webapps/manager");
        if (!managerDir.exists()) {
            final Project project = this.getProject();
            final File zipFile = FileUtil.get((Project)project, (String)this.getZipUrl());
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.eachFile((Action)new StripPathSegmentsAction(2));
                    copySpec.from(new Object[]{project.zipTree((Object)zipFile)});
                    copySpec.include(new String[]{"apache-tomcat-*/webapps/manager/**/*"});
                    copySpec.into((Object)managerDir.getParentFile());
                    copySpec.setIncludeEmptyDirs(false);
                }
            });
        }
        Document document = null;
        File tomcatUsersXmlFile = new File(this.getDir(), "conf/tomcat-users.xml");
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(tomcatUsersXmlFile));){
            document = DOMBuilder.parse((Reader)inputStreamReader);
        }
        Element tomcatUsersElement = document.getDocumentElement();
        HashSet<String> existentRoleNames = new HashSet<String>();
        boolean tomcatManagerUserExists = false;
        NodeList nodeList = tomcatUsersElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String userName;
            String[] node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("role")) {
                String roleName = element.getAttribute("rolename");
                existentRoleNames.add(roleName);
                continue;
            }
            if (!elementName.equals("user") || !(userName = element.getAttribute("username")).equals(this.getManagerUserName())) continue;
            tomcatManagerUserExists = true;
        }
        boolean tomcatUsersXmlFileModified = false;
        for (String roleName : _TOMCAT_USERS_ROLE_NAMES) {
            if (existentRoleNames.contains(roleName)) continue;
            Element element = document.createElement("role");
            element.setAttribute("rolename", roleName);
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (!tomcatManagerUserExists) {
            Element element = document.createElement("user");
            element.setAttribute("password", this.getManagerPassword());
            element.setAttribute("roles", "tomcat,manager-gui,manager-script,manager-jmx,manager-status");
            element.setAttribute("username", this.getManagerUserName());
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (tomcatUsersXmlFileModified) {
            Path timestampTomcatUserXmlFilePath = Paths.get(tomcatUsersXmlFile.toString() + "." + this._timestampDateFormat.format(new Date()), new String[0]);
            Files.copy(tomcatUsersXmlFile.toPath(), timestampTomcatUserXmlFilePath, new CopyOption[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tomcatUsersXmlFile);){
                XmlUtil.serialize((Element)tomcatUsersElement, (OutputStream)fileOutputStream);
            }
        }
    }

    private void _setUpOsgiModules() {
        Project project = this.getProject();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                File moduleFrameworkBaseDir = SetUpTestableTomcatTask.this.getModuleFrameworkBaseDir();
                File modulesDir = new File(moduleFrameworkBaseDir, "modules");
                if (!SetUpTestableTomcatTask.this.isOverwriteTestModules()) {
                    copySpec.eachFile((Action)new ExcludeExistingFileAction(modulesDir));
                }
                copySpec.from(new Object[]{new File(moduleFrameworkBaseDir, "test")});
                copySpec.into((Object)modulesDir);
            }
        });
    }

    private void _setUpSetEnv() throws Exception {
        this._setUpJaCoCo();
        this._setUpAspectJ();
        this._setUpJpda();
    }
}

