/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.tasks.StartAppServerTask;
import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.zeroturnaround.exec.StartedProcess;

@CacheableTask
public class StartTestableTomcatTask
extends StartAppServerTask {
    private boolean _deleteLiferayHome = true;
    private Object _liferayHome;

    @Input
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getLiferayHome() {
        return GradleUtil.toFile(this.getProject(), this._liferayHome);
    }

    @Input
    public boolean isDeleteLiferayHome() {
        return this._deleteLiferayHome;
    }

    public void setDeleteLiferayHome(boolean deleteLiferayHome) {
        this._deleteLiferayHome = deleteLiferayHome;
    }

    public void setLiferayHome(Object liferayHome) {
        this._liferayHome = liferayHome;
    }

    @Override
    public void startAppServer() throws Exception {
        if (this.isDeleteLiferayHome()) {
            this._deleteLiferayHome();
        }
        super.startAppServer();
    }

    @Override
    protected void waitForStarted(StartedProcess startedProcess, final OutputStream outputStream) {
        this.waitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String output = outputStream.toString();
                if (output.contains("Server startup in")) {
                    return true;
                }
                return false;
            }
        });
        super.waitForStarted(startedProcess, outputStream);
    }

    private void _deleteLiferayHome() {
        Project project = this.getProject();
        File liferayHome = this.getLiferayHome();
        if (liferayHome == null) {
            throw new InvalidUserDataException("No value has been specified for property 'liferayHome'");
        }
        project.delete(new Object[]{new File(liferayHome, "data"), new File(liferayHome, "logs"), new File(liferayHome, "osgi/state"), new File(liferayHome, "portal-setup-wizard.properties")});
    }
}

