/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.tasks.ModuleFrameworkBaseDirSpec;
import com.liferay.gradle.plugins.test.integration.tasks.StopAppServerTask;
import java.io.File;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class StopTestableTomcatTask
extends StopAppServerTask
implements ModuleFrameworkBaseDirSpec {
    private boolean _deleteTestModules = true;
    private Object _moduleFrameworkBaseDir;

    @Override
    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getModuleFrameworkBaseDir() {
        return GradleUtil.toFile(this.getProject(), this._moduleFrameworkBaseDir);
    }

    @Input
    public boolean isDeleteTestModules() {
        return this._deleteTestModules;
    }

    public void setDeleteTestModules(boolean deleteTestModules) {
        this._deleteTestModules = deleteTestModules;
    }

    @Override
    public void setModuleFrameworkBaseDir(Object moduleFrameworkBaseDir) {
        this._moduleFrameworkBaseDir = moduleFrameworkBaseDir;
    }

    @Override
    public void stopAppServer() throws Exception {
        super.stopAppServer();
        if (this.isDeleteTestModules()) {
            this._deleteTestModules();
        }
    }

    private void _deleteTestModules() {
        Logger logger = this.getLogger();
        File moduleFrameworkBaseDir = this.getModuleFrameworkBaseDir();
        File modulesDir = new File(moduleFrameworkBaseDir, "modules");
        File testDir = new File(moduleFrameworkBaseDir, "test");
        for (File file : testDir.listFiles()) {
            boolean deleted;
            File moduleFile = new File(modulesDir, file.getName());
            if (!moduleFile.exists() || (deleted = moduleFile.delete()) || !logger.isWarnEnabled()) continue;
            logger.warn("Unable to delete {}", (Object)moduleFile);
        }
    }
}

