/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.util.GUtil;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public abstract class BaseAppServerTask
extends DefaultTask {
    private Object _binDir;
    private long _checkInterval = 500L;
    private Object _checkPath;
    private long _checkTimeout = 600000L;
    private Object _executable;
    private final List<Object> _executableArgs = new ArrayList<Object>();
    private Object _hostName = "localhost";
    private Object _portNumber;

    public void executableArgs(Iterable<?> executableArgs) {
        GUtil.addToCollection(this._executableArgs, (Iterable[])new Iterable[]{executableArgs});
    }

    public void executableArgs(Object ... executableArgs) {
        this.executableArgs(Arrays.asList(executableArgs));
    }

    @Input
    public File getBinDir() {
        return GradleUtil.toFile(this.getProject(), this._binDir);
    }

    @Input
    public long getCheckInterval() {
        return this._checkInterval;
    }

    @Input
    public String getCheckPath() {
        return GradleUtil.toString((Object)this._checkPath);
    }

    @Input
    public long getCheckTimeout() {
        return this._checkTimeout;
    }

    @Input
    public String getExecutable() {
        return GradleUtil.toString((Object)this._executable);
    }

    @Input
    public List<String> getExecutableArgs() {
        List<Object> executableArgs = new ArrayList(this._executableArgs.size());
        for (Object object : this._executableArgs) {
            executableArgs.add(GradleUtil.toObject((Object)object));
        }
        executableArgs = GUtil.flatten(executableArgs);
        return GradleUtil.toStringList(executableArgs);
    }

    @Input
    public String getHostName() {
        return GradleUtil.toString((Object)this._hostName);
    }

    @Input
    public int getPortNumber() {
        return GradleUtil.toInteger((Object)this._portNumber);
    }

    public boolean isReachable() {
        try {
            URL url = new URL("http", this.getHostName(), this.getPortNumber(), this.getCheckPath());
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode > 0 && responseCode < 400) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setBinDir(Object binDir) {
        this._binDir = binDir;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval;
    }

    public void setCheckPath(Object checkPath) {
        this._checkPath = checkPath;
    }

    public void setCheckTimeout(long checkTimeout) {
        this._checkTimeout = checkTimeout;
    }

    public void setExecutable(Object executable) {
        this._executable = executable;
    }

    public void setExecutableArgs(Iterable<?> executableArgs) {
        this._executableArgs.clear();
        this.executableArgs(executableArgs);
    }

    public void setExecutableArgs(Object ... executableArgs) {
        this.setExecutableArgs(Arrays.asList(executableArgs));
    }

    public void setHostName(Object hostName) {
        this._hostName = hostName;
    }

    public void setPortNumber(Object portNumber) {
        this._portNumber = portNumber;
    }

    protected ProcessExecutor getProcessExecutor() {
        ArrayList<String> commands = new ArrayList<String>();
        File executableFile = new File(this.getBinDir(), this.getExecutable());
        commands.add(executableFile.getAbsolutePath());
        commands.addAll(this.getExecutableArgs());
        ProcessExecutor processExecutor = new ProcessExecutor(commands);
        processExecutor.directory(this.getBinDir());
        Slf4jStream slf4jStream = Slf4jStream.ofCaller();
        processExecutor.redirectOutput((OutputStream)slf4jStream.asWarn());
        return processExecutor;
    }

    protected void waitFor(Callable<Boolean> callable) {
        boolean success = false;
        try {
            success = GradleUtil.waitFor(callable, (long)this.getCheckInterval(), (long)this.getCheckTimeout());
        }
        catch (Exception e) {
            throw new GradleException("Unable to wait for the application server", (Throwable)e);
        }
        if (!success) {
            throw new GradleException("Timeout while waiting for the application server");
        }
    }
}

