/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.internal.util.StringUtil;
import com.liferay.gradle.plugins.test.integration.tasks.JmxRemotePortSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ManagerSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ModuleFrameworkBaseDirSpec;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.copy.ExcludeExistingFileAction;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.xml.DOMBuilder;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.VersionNumber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SetUpTestableTomcatTask
extends DefaultTask
implements JmxRemotePortSpec,
ManagerSpec,
ModuleFrameworkBaseDirSpec {
    private static final String[] _TOMCAT_USERS_ROLE_NAMES = new String[]{"manager-gui", "manager-jmx", "manager-script", "manager-status", "tomcat"};
    private final Map<String, Object> _catalinaOptsReplacements = new LinkedHashMap<String, Object>();
    private boolean _debugLogging;
    private Object _dir;
    private boolean _jmxRemoteAuthenticate;
    private Object _jmxRemotePort;
    private boolean _jmxRemoteSsl;
    private Object _managerPassword;
    private Object _managerUserName;
    private Object _moduleFrameworkBaseDir;
    private boolean _overwriteTestModules;
    private final DateFormat _timestampDateFormat = new SimpleDateFormat("yyyyMMddkkmmssSSS");
    private Object _zipUrl = new Callable<String>(){

        @Override
        public String call() throws Exception {
            File dir = SetUpTestableTomcatTask.this.getDir();
            String dirName = dir.getName();
            int start = StringUtil.indexOfDigit(dirName);
            if (start < 0) {
                return null;
            }
            VersionNumber versionNumber = VersionNumber.parse((String)dirName.substring(start));
            if (versionNumber == VersionNumber.UNKNOWN) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("http://archive.apache.org/dist/tomcat/tomcat-");
            sb.append(versionNumber.getMajor());
            sb.append("/v");
            sb.append(versionNumber);
            sb.append("/bin/apache-tomcat-");
            sb.append(versionNumber);
            sb.append(".zip");
            return sb.toString();
        }
    };

    public SetUpTestableTomcatTask catalinaOptsReplacement(String oldSub, Object newSub) {
        this._catalinaOptsReplacements.put(oldSub, newSub);
        return this;
    }

    public SetUpTestableTomcatTask catalinaOptsReplacements(Map<String, ?> catalinaOptsReplacements) {
        this._catalinaOptsReplacements.putAll(catalinaOptsReplacements);
        return this;
    }

    public File getBinDir() {
        return new File(this.getDir(), "bin");
    }

    @Input
    public Map<String, Object> getCatalinaOptsReplacements() {
        return this._catalinaOptsReplacements;
    }

    @Input
    public File getDir() {
        return GradleUtil.toFile(this.getProject(), this._dir);
    }

    @Override
    @Input
    public int getJmxRemotePort() {
        return GradleUtil.toInteger((Object)this._jmxRemotePort);
    }

    @Override
    @Input
    public String getManagerPassword() {
        return GradleUtil.toString((Object)this._managerPassword);
    }

    @Override
    @Input
    public String getManagerUserName() {
        return GradleUtil.toString((Object)this._managerUserName);
    }

    @Override
    @Input
    public File getModuleFrameworkBaseDir() {
        return GradleUtil.toFile(this.getProject(), this._moduleFrameworkBaseDir);
    }

    @Input
    public String getZipUrl() {
        return GradleUtil.toString((Object)this._zipUrl);
    }

    @Input
    public boolean isDebugLogging() {
        return this._debugLogging;
    }

    @Input
    public boolean isJmxRemoteAuthenticate() {
        return this._jmxRemoteAuthenticate;
    }

    @Input
    public boolean isJmxRemoteSsl() {
        return this._jmxRemoteSsl;
    }

    @Input
    public boolean isOverwriteTestModules() {
        return this._overwriteTestModules;
    }

    public void setCatalinaOptsReplacements(Map<String, ?> catalinaOptsReplacements) {
        this._catalinaOptsReplacements.clear();
        this.catalinaOptsReplacements(catalinaOptsReplacements);
    }

    public void setDebugLogging(boolean debugLogging) {
        this._debugLogging = debugLogging;
    }

    public void setDir(Object dir) {
        this._dir = dir;
    }

    public void setJmxRemoteAuthenticate(boolean jmxRemoteAuthenticate) {
        this._jmxRemoteAuthenticate = jmxRemoteAuthenticate;
    }

    @Override
    public void setJmxRemotePort(Object jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    public void setJmxRemoteSsl(boolean jmxRemoteSsl) {
        this._jmxRemoteSsl = jmxRemoteSsl;
    }

    @Override
    public void setManagerPassword(Object managerPassword) {
        this._managerPassword = managerPassword;
    }

    @Override
    public void setManagerUserName(Object managerUserName) {
        this._managerUserName = managerUserName;
    }

    @Override
    public void setModuleFrameworkBaseDir(Object moduleFrameworkBaseDir) {
        this._moduleFrameworkBaseDir = moduleFrameworkBaseDir;
    }

    public void setOverwriteTestModules(boolean overwriteTestModules) {
        this._overwriteTestModules = overwriteTestModules;
    }

    @TaskAction
    public void setUpTestableTomcat() throws Exception {
        this._setUpCatalinaOpts();
        this._setUpJmx();
        this._setUpLogging();
        this._setUpManager();
        this._setUpOsgiModules();
    }

    public void setZipUrl(Object zipUrl) {
        this._zipUrl = zipUrl;
    }

    private boolean _contains(String fileName, String s) throws IOException {
        File file = new File(this.getDir(), fileName);
        String fileContent = new String(Files.readAllBytes(file.toPath()));
        return fileContent.contains(s);
    }

    private PrintWriter _getAppendPrintWriter(String fileName) throws IOException {
        File file = new File(this.getDir(), fileName);
        return new PrintWriter(Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.WRITE));
    }

    private String _getJmxOptions() {
        StringBuilder sb = new StringBuilder();
        sb.append("-Dcom.sun.management.jmxremote ");
        sb.append("-Dcom.sun.management.jmxremote.authenticate=");
        sb.append(this.isJmxRemoteAuthenticate());
        sb.append(" -Dcom.sun.management.jmxremote.port=");
        sb.append(this.getJmxRemotePort());
        sb.append(" -Dcom.sun.management.jmxremote.ssl=");
        sb.append(this.isJmxRemoteSsl());
        return sb.toString();
    }

    private void _replace(String fileName, Map<String, Object> replacements) throws IOException {
        Logger logger = this.getLogger();
        File dir = this.getDir();
        Path dirPath = dir.toPath();
        Path path = dirPath.resolve(fileName);
        String content = new String(Files.readAllBytes(path));
        for (Map.Entry<String, Object> entry : replacements.entrySet()) {
            String oldSub = entry.getKey();
            String newSub = GradleUtil.toString((Object)entry.getValue());
            if (logger.isWarnEnabled() && !content.contains(oldSub)) {
                logger.warn("Unable to find \"{}\" in {}", (Object)oldSub, (Object)path);
            }
            content = content.replace(oldSub, newSub);
        }
        Files.write(path, content.getBytes(), new OpenOption[0]);
    }

    private void _setUpCatalinaOpts() throws IOException {
        Map<String, Object> replacements = this.getCatalinaOptsReplacements();
        if (replacements.isEmpty()) {
            return;
        }
        this._replace("bin/setenv.bat", replacements);
        this._replace("bin/setenv.sh", replacements);
    }

    private void _setUpJmx() throws IOException {
        Throwable throwable;
        PrintWriter printWriter;
        String jmxOptions = this._getJmxOptions();
        if (!this._contains("bin/setenv.bat", jmxOptions)) {
            printWriter = this._getAppendPrintWriter("bin/setenv.bat");
            throwable = null;
            try {
                printWriter.println();
                printWriter.print("set \"JMX_OPTS=");
                printWriter.print(jmxOptions);
                printWriter.println('\"');
                printWriter.println();
                printWriter.println("set \"CATALINA_OPTS=%CATALINA_OPTS% %JMX_OPTS%\"");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (printWriter != null) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        printWriter.close();
                    }
                }
            }
        }
        if (!this._contains("bin/setenv.sh", jmxOptions)) {
            printWriter = this._getAppendPrintWriter("bin/setenv.sh");
            throwable = null;
            try {
                printWriter.println();
                printWriter.print("JMX_OPTS=\"");
                printWriter.print(jmxOptions);
                printWriter.println('\"');
                printWriter.println();
                printWriter.println("CATALINA_OPTS=\"${CATALINA_OPTS} ${JMX_OPTS}\"");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (printWriter != null) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        printWriter.close();
                    }
                }
            }
        }
    }

    private void _setUpLogging() throws IOException {
        if (!this.isDebugLogging() || this._contains("conf/Logging.properties", "org.apache.catalina.level")) {
            return;
        }
        try (PrintWriter printWriter = this._getAppendPrintWriter("conf/Logging.properties");){
            printWriter.println("org.apache.catalina.level=ALL");
            printWriter.println();
            printWriter.println("org.apache.catalina.loader.WebappClassLoader.level=INFO");
            printWriter.println("org.apache.catalina.loader.WebappLoader.level=INFO");
            printWriter.println("org.apache.catalina.startup.ClassLoaderFactory.level=INFO");
        }
    }

    private void _setUpManager() throws Exception {
        final File managerDir = new File(this.getDir(), "webapps/manager");
        if (!managerDir.exists()) {
            final Project project = this.getProject();
            final File zipFile = FileUtil.get((Project)project, (String)this.getZipUrl());
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.eachFile((Action)new StripPathSegmentsAction(2));
                    copySpec.from(new Object[]{project.zipTree((Object)zipFile)});
                    copySpec.include(new String[]{"apache-tomcat-*/webapps/manager/**/*"});
                    copySpec.into((Object)managerDir.getParentFile());
                    copySpec.setIncludeEmptyDirs(false);
                }
            });
        }
        Document document = null;
        File tomcatUsersXmlFile = new File(this.getDir(), "conf/tomcat-users.xml");
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(tomcatUsersXmlFile));){
            document = DOMBuilder.parse((Reader)inputStreamReader);
        }
        Element tomcatUsersElement = document.getDocumentElement();
        HashSet<String> existentRoleNames = new HashSet<String>();
        boolean tomcatManagerUserExists = false;
        NodeList nodeList = tomcatUsersElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String userName;
            String[] node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("role")) {
                String roleName = element.getAttribute("rolename");
                existentRoleNames.add(roleName);
                continue;
            }
            if (!elementName.equals("user") || !(userName = element.getAttribute("username")).equals(this.getManagerUserName())) continue;
            tomcatManagerUserExists = true;
        }
        boolean tomcatUsersXmlFileModified = false;
        for (String roleName : _TOMCAT_USERS_ROLE_NAMES) {
            if (existentRoleNames.contains(roleName)) continue;
            Element element = document.createElement("role");
            element.setAttribute("rolename", roleName);
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (!tomcatManagerUserExists) {
            Element element = document.createElement("user");
            element.setAttribute("password", this.getManagerPassword());
            element.setAttribute("roles", "tomcat,manager-gui,manager-script,manager-jmx,manager-status");
            element.setAttribute("username", this.getManagerUserName());
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (tomcatUsersXmlFileModified) {
            Path timestampTomcatUserXmlFilePath = Paths.get(tomcatUsersXmlFile.toString() + "." + this._timestampDateFormat.format(new Date()), new String[0]);
            Files.copy(tomcatUsersXmlFile.toPath(), timestampTomcatUserXmlFilePath, new CopyOption[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tomcatUsersXmlFile);){
                XmlUtil.serialize((Element)tomcatUsersElement, (OutputStream)fileOutputStream);
            }
        }
    }

    private void _setUpOsgiModules() {
        Project project = this.getProject();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                File moduleFrameworkBaseDir = SetUpTestableTomcatTask.this.getModuleFrameworkBaseDir();
                File modulesDir = new File(moduleFrameworkBaseDir, "modules");
                if (!SetUpTestableTomcatTask.this.isOverwriteTestModules()) {
                    copySpec.eachFile((Action)new ExcludeExistingFileAction(modulesDir));
                }
                copySpec.from(new Object[]{new File(moduleFrameworkBaseDir, "test")});
                copySpec.into((Object)modulesDir);
            }
        });
    }
}

