/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration.tasks;

import com.liferay.gradle.plugins.test.integration.tasks.JmxRemotePortSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ManagerSpec;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import groovy.xml.DOMBuilder;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetupTestableTomcatTask
extends DefaultTask
implements JmxRemotePortSpec,
ManagerSpec {
    private static final String[] _TOMCAT_USERS_ROLE_NAMES = new String[]{"manager-gui", "manager-jmx", "manager-script", "manager-status", "tomcat"};
    private boolean _debugLogging;
    private Object _dir;
    private boolean _jmxRemoteAuthenticate;
    private Object _jmxRemotePort;
    private boolean _jmxRemoteSsl;
    private Object _managerPassword;
    private Object _managerUserName;
    private Object _moduleFrameworkBaseDir;
    private final DateFormat _timestampDateFormat = new SimpleDateFormat("yyyyMMddkkmmssSSS");
    private Object _zipUrl;

    public File getBinDir() {
        return new File(this.getDir(), "bin");
    }

    @Input
    public File getDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._dir);
    }

    @Override
    @Input
    public int getJmxRemotePort() {
        return GradleUtil.toInteger((Object)this._jmxRemotePort);
    }

    @Override
    @Input
    public String getManagerPassword() {
        return GradleUtil.toString((Object)this._managerPassword);
    }

    @Override
    @Input
    public String getManagerUserName() {
        return GradleUtil.toString((Object)this._managerUserName);
    }

    @Input
    public File getModuleFrameworkBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._moduleFrameworkBaseDir);
    }

    @Input
    public String getZipUrl() {
        return GradleUtil.toString((Object)this._zipUrl);
    }

    @Input
    public boolean isDebugLogging() {
        return this._debugLogging;
    }

    @Input
    public boolean isJmxRemoteAuthenticate() {
        return this._jmxRemoteAuthenticate;
    }

    @Input
    public boolean isJmxRemoteSsl() {
        return this._jmxRemoteSsl;
    }

    public void setDebugLogging(boolean debugLogging) {
        this._debugLogging = debugLogging;
    }

    public void setDir(Object dir) {
        this._dir = dir;
    }

    public void setJmxRemoteAuthenticate(boolean jmxRemoteAuthenticate) {
        this._jmxRemoteAuthenticate = jmxRemoteAuthenticate;
    }

    @Override
    public void setJmxRemotePort(Object jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    public void setJmxRemoteSsl(boolean jmxRemoteSsl) {
        this._jmxRemoteSsl = jmxRemoteSsl;
    }

    @Override
    public void setManagerPassword(Object managerPassword) {
        this._managerPassword = managerPassword;
    }

    @Override
    public void setManagerUserName(Object managerUserName) {
        this._managerUserName = managerUserName;
    }

    public void setModuleFrameworkBaseDir(Object moduleFrameworkBaseDir) {
        this._moduleFrameworkBaseDir = moduleFrameworkBaseDir;
    }

    @TaskAction
    public void setupTestableTomcat() throws Exception {
        this.setupJmx();
        this.setupLogging();
        this.setupManager();
        this.setupOsgiModules();
    }

    public void setZipUrl(Object zipUrl) {
        this._zipUrl = zipUrl;
    }

    protected boolean contains(String fileName, String s) throws Exception {
        File file = new File(this.getDir(), fileName);
        String fileContent = new String(Files.readAllBytes(file.toPath()));
        return fileContent.contains(s);
    }

    protected PrintWriter getAppendPrintWriter(String fileName) throws Exception {
        File file = new File(this.getDir(), fileName);
        return new PrintWriter(Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.WRITE));
    }

    protected String getJmxOptions() {
        StringBuilder sb = new StringBuilder();
        sb.append("-Dcom.sun.management.jmxremote");
        sb.append(" -Dcom.sun.management.jmxremote.authenticate=");
        sb.append(this.isJmxRemoteAuthenticate());
        sb.append(" -Dcom.sun.management.jmxremote.port=");
        sb.append(this.getJmxRemotePort());
        sb.append(" -Dcom.sun.management.jmxremote.ssl=");
        sb.append(this.isJmxRemoteSsl());
        return sb.toString();
    }

    protected void setupJmx() throws Exception {
        Throwable throwable;
        PrintWriter printWriter;
        String jmxOptions = this.getJmxOptions();
        if (!this.contains("bin/setenv.bat", jmxOptions)) {
            printWriter = this.getAppendPrintWriter("bin/setenv.bat");
            throwable = null;
            try {
                printWriter.println();
                printWriter.print("set \"JMX_OPTS=");
                printWriter.print(jmxOptions);
                printWriter.println('\"');
                printWriter.println();
                printWriter.println("set \"CATALINA_OPTS=%CATALINA_OPTS% %JMX_OPTS%\"");
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (printWriter != null) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        printWriter.close();
                    }
                }
            }
        }
        if (!this.contains("bin/setenv.sh", jmxOptions)) {
            printWriter = this.getAppendPrintWriter("bin/setenv.sh");
            throwable = null;
            try {
                printWriter.print("JMX_OPTS=\"");
                printWriter.print(jmxOptions);
                printWriter.println('\"');
                printWriter.println();
                printWriter.println("CATALINA_OPTS=\"${CATALINA_OPTS} ${JMX_OPTS}\"");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (printWriter != null) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        printWriter.close();
                    }
                }
            }
        }
    }

    protected void setupLogging() throws Exception {
        if (!this.isDebugLogging() || this.contains("conf/Logging.properties", "org.apache.catalina.level")) {
            return;
        }
        try (PrintWriter printWriter = this.getAppendPrintWriter("conf/Logging.properties");){
            printWriter.println("org.apache.catalina.level=ALL");
            printWriter.println();
            printWriter.println("org.apache.catalina.loader.WebappClassLoader.level=INFO");
            printWriter.println("org.apache.catalina.loader.WebappLoader.level=INFO");
            printWriter.println("org.apache.catalina.startup.ClassLoaderFactory.level=INFO");
        }
    }

    protected void setupManager() throws Exception {
        final File managerDir = new File(this.getDir(), "webapps/manager");
        if (!managerDir.exists()) {
            final Project project = this.getProject();
            final File zipFile = FileUtil.get((Project)project, (String)this.getZipUrl());
            Closure<Void> closure = new Closure<Void>(null){

                public void doCall(CopySpec copySpec) {
                    copySpec.eachFile((Action)new StripPathSegmentsAction(2));
                    copySpec.from(new Object[]{project.zipTree((Object)zipFile)});
                    copySpec.include(new String[]{"apache-tomcat-*/webapps/manager/**/*"});
                    copySpec.into((Object)managerDir.getParentFile());
                    copySpec.setIncludeEmptyDirs(false);
                }
            };
            project.copy((Closure)closure);
        }
        Document document = null;
        File tomcatUsersXmlFile = new File(this.getDir(), "conf/tomcat-users.xml");
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(tomcatUsersXmlFile));){
            document = DOMBuilder.parse((Reader)inputStreamReader);
        }
        Element tomcatUsersElement = document.getDocumentElement();
        HashSet<String> existentRoleNames = new HashSet<String>();
        boolean tomcatManagerUserExists = false;
        NodeList nodeList = tomcatUsersElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String userName;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("role")) {
                String roleName = element.getAttribute("rolename");
                existentRoleNames.add(roleName);
                continue;
            }
            if (!elementName.equals("user") || !(userName = element.getAttribute("username")).equals(this.getManagerUserName())) continue;
            tomcatManagerUserExists = true;
        }
        boolean tomcatUsersXmlFileModified = false;
        for (String roleName : _TOMCAT_USERS_ROLE_NAMES) {
            if (existentRoleNames.contains(roleName)) continue;
            Element element = document.createElement("role");
            element.setAttribute("rolename", roleName);
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (!tomcatManagerUserExists) {
            Element element = document.createElement("user");
            element.setAttribute("password", this.getManagerPassword());
            element.setAttribute("roles", "tomcat,manager-gui,manager-script,manager-jmx,manager-status");
            element.setAttribute("username", this.getManagerUserName());
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (tomcatUsersXmlFileModified) {
            Path timestampTomcatUserXmlFilePath = Paths.get(tomcatUsersXmlFile.toString() + "." + this._timestampDateFormat.format(new Date()), new String[0]);
            Files.copy(tomcatUsersXmlFile.toPath(), timestampTomcatUserXmlFilePath, new CopyOption[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tomcatUsersXmlFile);){
                XmlUtil.serialize((Element)tomcatUsersElement, (OutputStream)fileOutputStream);
            }
        }
    }

    protected void setupOsgiModules() {
        Project project = this.getProject();
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                File moduleFrameworkBaseDir = SetupTestableTomcatTask.this.getModuleFrameworkBaseDir();
                copySpec.from(new Object[]{new File(moduleFrameworkBaseDir, "test")});
                copySpec.into((Object)new File(moduleFrameworkBaseDir, "modules"));
            }
        };
        project.copy((Closure)closure);
    }
}

