/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration;

import com.liferay.gradle.plugins.test.integration.TestIntegrationBasePlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationTomcatExtension;
import com.liferay.gradle.plugins.test.integration.tasks.BaseAppServerTask;
import com.liferay.gradle.plugins.test.integration.tasks.JmxRemotePortSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ManagerSpec;
import com.liferay.gradle.plugins.test.integration.tasks.SetupArquillianTask;
import com.liferay.gradle.plugins.test.integration.tasks.SetupTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StartTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StopAppServerTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.testing.Test;

public class TestIntegrationPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "testIntegration";
    public static final String SETUP_ARQUILLIAN_TASK_NAME = "setupArquillian";
    public static final String SETUP_TESTABLE_TOMCAT_TASK_NAME = "setupTestableTomcat";
    public static final String START_TESTABLE_TOMCAT_TASK_NAME = "startTestableTomcat";
    public static final String STOP_TESTABLE_TOMCAT_TASK_NAME = "stopTestableTomcat";
    private static final String _SKIP_MANAGED_APP_SERVER_FILE_NAME = "skip.managed.app.server";
    private static final Logger _logger = Logging.getLogger(TestIntegrationPlugin.class);
    private static final Set<File> _startedAppServerBinDirs = new HashSet<File>();
    private static final ReentrantLock _startedAppServersReentrantLock = new ReentrantLock();
    private static final Map<File, Integer> _startedAppServerStopCounters = new HashMap<File, Integer>();

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, TestIntegrationBasePlugin.class);
        final SourceSet testIntegrationSourceSet = GradleUtil.getSourceSet((Project)project, (String)PLUGIN_NAME);
        final Test testIntegrationTask = (Test)GradleUtil.getTask((Project)project, (String)PLUGIN_NAME);
        final TestIntegrationTomcatExtension testIntegrationTomcatExtension = (TestIntegrationTomcatExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"testIntegrationTomcat", TestIntegrationTomcatExtension.class);
        SetupTestableTomcatTask setupTestableTomcatTask = this.addTaskSetupTestableTomcat(project, testIntegrationTomcatExtension);
        StopAppServerTask stopTestableTomcatTask = this.addTaskStopTestableTomcat(project, testIntegrationTask, testIntegrationTomcatExtension);
        StartTestableTomcatTask startTestableTomcatTask = this.addTaskStartTestableTomcat(project, setupTestableTomcatTask, stopTestableTomcatTask, testIntegrationTomcatExtension);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                SetupArquillianTask setupArquillianTask = TestIntegrationPlugin.this.addTaskSetupArquillian(project, testIntegrationSourceSet, testIntegrationTomcatExtension);
                testIntegrationTask.dependsOn(new Object[]{setupArquillianTask});
            }
        });
        this.configureTaskTestIntegration(testIntegrationTask, testIntegrationSourceSet, testIntegrationTomcatExtension, startTestableTomcatTask);
    }

    protected SetupArquillianTask addTaskSetupArquillian(Project project, final SourceSet testIntegrationSourceSet, TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        SetupArquillianTask setupArquillianTask = (SetupArquillianTask)GradleUtil.addTask((Project)project, (String)SETUP_ARQUILLIAN_TASK_NAME, SetupArquillianTask.class);
        setupArquillianTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return TestIntegrationPlugin.this.getSrcDir(testIntegrationSourceSet.getResources());
            }
        });
        this.configureJmxRemotePortSpec(setupArquillianTask, testIntegrationTomcatExtension);
        this.configureManagerSpec(setupArquillianTask, testIntegrationTomcatExtension);
        return setupArquillianTask;
    }

    protected SetupTestableTomcatTask addTaskSetupTestableTomcat(Project project, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final SetupTestableTomcatTask setupTestableTomcatTask = (SetupTestableTomcatTask)GradleUtil.addTask((Project)project, (String)SETUP_TESTABLE_TOMCAT_TASK_NAME, SetupTestableTomcatTask.class);
        setupTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isSatisfiedBy(Task task) {
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(setupTestableTomcatTask.getBinDir())) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        });
        setupTestableTomcatTask.setDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getDir();
            }
        });
        setupTestableTomcatTask.setModuleFrameworkBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(testIntegrationTomcatExtension.getLiferayHome(), "osgi");
            }
        });
        this.configureJmxRemotePortSpec(setupTestableTomcatTask, testIntegrationTomcatExtension);
        this.configureManagerSpec(setupTestableTomcatTask, testIntegrationTomcatExtension);
        return setupTestableTomcatTask;
    }

    protected StartTestableTomcatTask addTaskStartTestableTomcat(Project project, SetupTestableTomcatTask setupTestableTomcatTask, StopAppServerTask stopTestableTomcatTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)GradleUtil.addTask((Project)project, (String)START_TESTABLE_TOMCAT_TASK_NAME, StartTestableTomcatTask.class);
        startTestableTomcatTask.dependsOn(new Object[]{setupTestableTomcatTask});
        Action<Task> action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)task;
                File binDir = startTestableTomcatTask.getBinDir();
                boolean started = false;
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(binDir)) {
                        started = true;
                    } else {
                        _startedAppServerBinDirs.add(binDir);
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
                if (started) {
                    Project project;
                    Gradle gradle;
                    StartParameter startParameter;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Application server " + binDir + " is already started");
                    }
                    if ((startParameter = (gradle = (project = startTestableTomcatTask.getProject()).getGradle()).getStartParameter()).isParallelProjectExecutionEnabled()) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Waiting for application server " + binDir + " to be reachable");
                        }
                        startTestableTomcatTask.waitForAppServer();
                    }
                    throw new StopExecutionException();
                }
            }
        };
        startTestableTomcatTask.doFirst((Action)action);
        startTestableTomcatTask.finalizedBy(new Object[]{stopTestableTomcatTask});
        startTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)task;
                return !startTestableTomcatTask.isReachable();
            }
        });
        startTestableTomcatTask.setLiferayHome(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getLiferayHome();
            }
        });
        this.configureBaseAppServerTask(startTestableTomcatTask, testIntegrationTomcatExtension);
        return startTestableTomcatTask;
    }

    protected StopAppServerTask addTaskStopTestableTomcat(Project project, Test testIntegrationTask, TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final StopAppServerTask stopTestableTomcatTask = (StopAppServerTask)GradleUtil.addTask((Project)project, (String)STOP_TESTABLE_TOMCAT_TASK_NAME, StopAppServerTask.class);
        Action<Task> action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StopAppServerTask stopAppServerTask = (StopAppServerTask)task;
                File binDir = stopAppServerTask.getBinDir();
                _startedAppServersReentrantLock.lock();
                try {
                    if (!_startedAppServerBinDirs.contains(binDir)) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Application server " + binDir + " is already stopped");
                        }
                        throw new StopExecutionException();
                    }
                    int originalCounter = TestIntegrationPlugin.this._updateStartedAppServerStopCounters(binDir, false);
                    if (originalCounter > 1) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Application server " + binDir + " cannot be stopped now, still " + (originalCounter - 1) + " to execute");
                        }
                        throw new StopExecutionException();
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        };
        stopTestableTomcatTask.doFirst((Action)action);
        stopTestableTomcatTask.mustRunAfter(new Object[]{testIntegrationTask});
        this.configureBaseAppServerTask(stopTestableTomcatTask, testIntegrationTomcatExtension);
        Gradle gradle = project.getGradle();
        TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
        Closure<Void> closure = new Closure<Void>(null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doCall(TaskExecutionGraph taskExecutionGraph) {
                if (taskExecutionGraph.hasTask((Task)stopTestableTomcatTask)) {
                    _startedAppServersReentrantLock.lock();
                    try {
                        TestIntegrationPlugin.this._updateStartedAppServerStopCounters(stopTestableTomcatTask.getBinDir(), true);
                    }
                    finally {
                        _startedAppServersReentrantLock.unlock();
                    }
                }
            }
        };
        taskExecutionGraph.whenReady((Closure)closure);
        return stopTestableTomcatTask;
    }

    protected void configureBaseAppServerTask(BaseAppServerTask baseAppServerTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        baseAppServerTask.setBinDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(testIntegrationTomcatExtension.getDir(), "bin");
            }
        });
        baseAppServerTask.setCheckPath(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getCheckPath();
            }
        });
        baseAppServerTask.setPortNumber(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testIntegrationTomcatExtension.getPortNumber();
            }
        });
    }

    protected void configureJmxRemotePortSpec(JmxRemotePortSpec jmxRemotePortSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        jmxRemotePortSpec.setJmxRemotePort(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testIntegrationTomcatExtension.getJmxRemotePort();
            }
        });
    }

    protected void configureManagerSpec(ManagerSpec managerSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        managerSpec.setManagerPassword(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getManagerPassword();
            }
        });
        managerSpec.setManagerUserName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getManagerUserName();
            }
        });
    }

    protected void configureTaskTestIntegration(final Test test, final SourceSet testIntegrationSourceSet, final TestIntegrationTomcatExtension testIntegrationTomcatExtension, final StartTestableTomcatTask startTestableTomcatTask) {
        Closure<Task> closure = new Closure<Task>(null){

            public Task doCall(Test test) {
                FileTree candidateClassFiles = test.getCandidateClassFiles();
                File srcDir = TestIntegrationPlugin.this.getSrcDir(testIntegrationSourceSet.getResources());
                File skipManagedAppServerFile = new File(srcDir, TestIntegrationPlugin._SKIP_MANAGED_APP_SERVER_FILE_NAME);
                if (!candidateClassFiles.isEmpty() && !skipManagedAppServerFile.exists()) {
                    return startTestableTomcatTask;
                }
                return null;
            }
        };
        test.dependsOn(new Object[]{closure});
        test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true"});
        test.jvmArgs(new Object[]{"-Dliferay.mode=test"});
        test.jvmArgs(new Object[]{"-Duser.timezone=GMT"});
        Project project = test.getProject();
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Map systemProperties = test.getSystemProperties();
                if (!systemProperties.containsKey("app.server.tomcat.dir")) {
                    systemProperties.put("app.server.tomcat.dir", FileUtil.getAbsolutePath((File)testIntegrationTomcatExtension.getDir()));
                }
            }
        });
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    private int _updateStartedAppServerStopCounters(File binDir, boolean increment) {
        int originalCounter = 0;
        if (_startedAppServerStopCounters.containsKey(binDir)) {
            originalCounter = _startedAppServerStopCounters.get(binDir);
        }
        int counter = originalCounter;
        counter = increment ? ++counter : --counter;
        _startedAppServerStopCounters.put(binDir, counter);
        return originalCounter;
    }
}

