/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.tasks;

import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.clauses.HeaderClause;
import aQute.bnd.build.model.conversions.Converter;
import aQute.bnd.gradle.FileSetRepositoryConvention;
import aQute.bnd.gradle.PropertiesWrapper;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.RepositoryPlugin;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.StartParameter;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.Convention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.osgi.service.resolver.ResolutionException;

public class ResolveTask
extends DefaultTask {
    private static Converter<List<String>, Collection<? extends HeaderClause>> _runbundlesFormatter = new Converter<List<String>, Collection<? extends HeaderClause>>(){

        public List<String> convert(Collection<? extends HeaderClause> input) throws IllegalArgumentException {
            Stream<? extends HeaderClause> stream = input.stream();
            return stream.map(HeaderClause::toString).collect(Collectors.toList());
        }

        public List<String> error(String msg) {
            return null;
        }
    };
    private Object _bndrunFile;
    private FileCollection _distroFileCollection;
    private Object _failOnChanges = Boolean.FALSE;
    private Object _offline;
    private Object _reportOptional = Boolean.TRUE;
    private List<String> _runBundles = Collections.emptyList();

    public ResolveTask() {
        Project project = this.getProject();
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        this._offline = startParameter.isOffline();
        Convention convention = this.getConvention();
        Map plugins = convention.getPlugins();
        plugins.put("bundles", new FileSetRepositoryConvention((Task)this));
    }

    @InputFile
    public File getBndrunFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._bndrunFile);
    }

    @InputFile
    public File getDistroFile() {
        return this._distroFileCollection.getSingleFile();
    }

    public List<String> getRunBundles() {
        return this._runBundles;
    }

    @Input
    public boolean isFailOnChanges() {
        return GradleUtil.toBoolean(this._failOnChanges);
    }

    public boolean isOffline() {
        return GradleUtil.toBoolean(this._offline);
    }

    @Input
    public boolean isReportOptional() {
        return GradleUtil.toBoolean(this._reportOptional);
    }

    @TaskAction
    public void resolve() throws Exception {
        Logger logger = this.getLogger();
        Project project = this.getProject();
        File bndrunFile = this.getBndrunFile();
        File temporaryDir = this.getTemporaryDir();
        try (Bndrun bndrun = Bndrun.createBndrun(null, (File)bndrunFile);){
            Workspace workspace = bndrun.getWorkspace();
            bndrun.setBase(temporaryDir);
            workspace.setOffline(this.isOffline());
            File cnfDir = new File(temporaryDir, "cnf");
            project.mkdir((Object)cnfDir);
            workspace.setBuildDir(cnfDir);
            Convention convention = this.getConvention();
            FileSetRepositoryConvention fileSetRepositoryConvention = (FileSetRepositoryConvention)convention.findPlugin(FileSetRepositoryConvention.class);
            if (fileSetRepositoryConvention != null) {
                workspace.addBasicPlugin((Object)fileSetRepositoryConvention.getFileSetRepository(this.getName()));
                for (RepositoryPlugin repositoryPlugin : workspace.getRepositories()) {
                    repositoryPlugin.list(null);
                }
            }
            bndrun.getInfo((Reporter)workspace);
            this._logReport((Report)bndrun, logger);
            if (!bndrun.isOk()) {
                throw new GradleException(bndrun.getPropertiesFile() + " has workspace errors");
            }
            try {
                PropertiesWrapper gradleProperties = new PropertiesWrapper();
                gradleProperties.put("project", project);
                File distroFile = this.getDistroFile();
                String distroReference = distroFile.getAbsolutePath() + ";version=file";
                gradleProperties.put("targetPlatformDistro", distroReference);
                gradleProperties.put("task", (Object)this);
                ProcessorWrapper processor = new ProcessorWrapper((Properties)gradleProperties);
                processor.setParent(bndrun.getParent());
                bndrun.setParent((Processor)processor);
                logger.info("Resolving bundles required for {}", (Object)bndrun.getPropertiesFile());
                this._runBundles = (List)bndrun.resolve(this.isFailOnChanges(), false, _runbundlesFormatter);
                Stream stream = this._runBundles.stream();
                logger.lifecycle("{}:\n    {}", new Object[]{"-runbundles", stream.collect(Collectors.joining("\n    "))});
            }
            catch (ResolutionException resolutionException) {
                logger.error(ResolveProcess.format((ResolutionException)resolutionException, (boolean)this.isReportOptional()));
                throw new GradleException(bndrun.getPropertiesFile() + " resolution exception", (Throwable)resolutionException);
            }
            finally {
                this._logReport((Report)bndrun, logger);
            }
            if (!bndrun.isOk()) {
                throw new GradleException(bndrun.getPropertiesFile() + " resolution failure");
            }
        }
    }

    public void setBndrunFile(Object bndrunFile) {
        this._bndrunFile = bndrunFile;
    }

    public void setDistro(FileCollection distroFileCollection) {
        this._distroFileCollection = distroFileCollection;
    }

    public void setFailOnChanges(Object failOnChanges) {
        this._failOnChanges = failOnChanges;
    }

    public void setOffline(Object offline) {
        this._offline = offline;
    }

    public void setReportOptional(Object reportOptional) {
        this._reportOptional = reportOptional;
    }

    private void _logReport(Report report, Logger logger) {
        Report.Location location;
        if (logger.isWarnEnabled()) {
            for (String warning : report.getWarnings()) {
                location = report.getLocation(warning);
                if (location != null && location.file != null) {
                    logger.warn("{}:{}: warning: {}", new Object[]{location.file, location.line, warning});
                    continue;
                }
                logger.warn("Warning: {}", (Object)warning);
            }
        }
        if (logger.isErrorEnabled()) {
            for (String error : report.getErrors()) {
                location = report.getLocation(error);
                if (location != null && location.file != null) {
                    logger.error("{}:{}: error: {}", new Object[]{location.file, location.line, error});
                    continue;
                }
                logger.error("Error: {}", (Object)error);
            }
        }
    }

    private static class ProcessorWrapper
    extends Processor {
        private final Properties _internalProperties;

        public ProcessorWrapper(Properties internalProperties) {
            this._internalProperties = internalProperties;
        }

        public Properties getProperties() {
            return this._internalProperties;
        }
    }
}

